package zio.aws.appstream.model
import java.lang.Integer
import zio.ZIO
import zio.aws.appstream.model.primitives.{DescribeImagesMaxResults, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeImagesRequest(
    names: Option[Iterable[String]] = None,
    arns: Option[Iterable[Arn]] = None,
    `type`: Option[zio.aws.appstream.model.VisibilityType] = None,
    nextToken: Option[String] = None,
    maxResults: Option[DescribeImagesMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeImagesRequest = {
    import DescribeImagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeImagesRequest
      .builder()
      .optionallyWith(
        names.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.names)
      .optionallyWith(
        arns.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.arns)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => DescribeImagesMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.DescribeImagesRequest.ReadOnly =
    zio.aws.appstream.model.DescribeImagesRequest.wrap(buildAwsValue())
}
object DescribeImagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeImagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DescribeImagesRequest =
      zio.aws.appstream.model.DescribeImagesRequest(
        names.map(value => value),
        arns.map(value => value),
        `type`.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def names: Option[List[String]]
    def arns: Option[List[Arn]]
    def `type`: Option[zio.aws.appstream.model.VisibilityType]
    def nextToken: Option[String]
    def maxResults: Option[DescribeImagesMaxResults]
    def getNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("names", names)
    def getArns: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("arns", arns)
    def getType: ZIO[Any, AwsError, zio.aws.appstream.model.VisibilityType] =
      AwsError.unwrapOptionField("type", `type`)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, DescribeImagesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeImagesRequest
  ) extends zio.aws.appstream.model.DescribeImagesRequest.ReadOnly {
    override val names: Option[List[String]] = scala
      .Option(impl.names())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val arns: Option[List[Arn]] = scala
      .Option(impl.arns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.primitives.Arn(item)
        }.toList
      )
    override val `type`: Option[zio.aws.appstream.model.VisibilityType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.appstream.model.VisibilityType.wrap(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[DescribeImagesMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.appstream.model.primitives.DescribeImagesMaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeImagesRequest
  ): zio.aws.appstream.model.DescribeImagesRequest.ReadOnly = new Wrapper(impl)
}
