package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{Integer, Arn, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeApplicationFleetAssociationsRequest(
    fleetName: Option[Name] = None,
    applicationArn: Option[Arn] = None,
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeApplicationFleetAssociationsRequest = {
    import DescribeApplicationFleetAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeApplicationFleetAssociationsRequest
      .builder()
      .optionallyWith(
        fleetName.map(value => Name.unwrap(value): java.lang.String)
      )(_.fleetName)
      .optionallyWith(
        applicationArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.applicationArn)
      .optionallyWith(
        maxResults.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.DescribeApplicationFleetAssociationsRequest.ReadOnly =
    zio.aws.appstream.model.DescribeApplicationFleetAssociationsRequest
      .wrap(buildAwsValue())
}
object DescribeApplicationFleetAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeApplicationFleetAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appstream.model.DescribeApplicationFleetAssociationsRequest =
      zio.aws.appstream.model.DescribeApplicationFleetAssociationsRequest(
        fleetName.map(value => value),
        applicationArn.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def fleetName: Option[Name]
    def applicationArn: Option[Arn]
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def getFleetName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("fleetName", fleetName)
    def getApplicationArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("applicationArn", applicationArn)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeApplicationFleetAssociationsRequest
  ) extends zio.aws.appstream.model.DescribeApplicationFleetAssociationsRequest.ReadOnly {
    override val fleetName: Option[Name] = scala
      .Option(impl.fleetName())
      .map(value => zio.aws.appstream.model.primitives.Name(value))
    override val applicationArn: Option[Arn] = scala
      .Option(impl.applicationArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val maxResults: Option[Integer] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.appstream.model.primitives.Integer(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeApplicationFleetAssociationsRequest
  ): zio.aws.appstream.model.DescribeApplicationFleetAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
