package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeUsersRequest(
    authenticationType: zio.aws.appstream.model.AuthenticationType,
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeUsersRequest = {
    import DescribeUsersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeUsersRequest
      .builder()
      .authenticationType(authenticationType.unwrap)
      .optionallyWith(
        maxResults.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.DescribeUsersRequest.ReadOnly =
    zio.aws.appstream.model.DescribeUsersRequest.wrap(buildAwsValue())
}
object DescribeUsersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeUsersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DescribeUsersRequest =
      zio.aws.appstream.model.DescribeUsersRequest(
        authenticationType,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def authenticationType: zio.aws.appstream.model.AuthenticationType
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def getAuthenticationType
        : ZIO[Any, Nothing, zio.aws.appstream.model.AuthenticationType] =
      ZIO.succeed(authenticationType)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeUsersRequest
  ) extends zio.aws.appstream.model.DescribeUsersRequest.ReadOnly {
    override val authenticationType
        : zio.aws.appstream.model.AuthenticationType =
      zio.aws.appstream.model.AuthenticationType.wrap(impl.authenticationType())
    override val maxResults: Option[Integer] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.appstream.model.primitives.Integer(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeUsersRequest
  ): zio.aws.appstream.model.DescribeUsersRequest.ReadOnly = new Wrapper(impl)
}
