package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{
  DisplayName,
  TagValue,
  Description,
  RedirectURL,
  Name,
  EmbedHostDomain,
  FeedbackURL,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateStackRequest(
    name: Name,
    description: Option[Description] = None,
    displayName: Option[DisplayName] = None,
    storageConnectors: Option[
      Iterable[zio.aws.appstream.model.StorageConnector]
    ] = None,
    redirectURL: Option[RedirectURL] = None,
    feedbackURL: Option[FeedbackURL] = None,
    userSettings: Option[Iterable[zio.aws.appstream.model.UserSetting]] = None,
    applicationSettings: Option[zio.aws.appstream.model.ApplicationSettings] =
      None,
    tags: Option[Map[TagKey, TagValue]] = None,
    accessEndpoints: Option[Iterable[zio.aws.appstream.model.AccessEndpoint]] =
      None,
    embedHostDomains: Option[Iterable[EmbedHostDomain]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CreateStackRequest = {
    import CreateStackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CreateStackRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        storageConnectors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.storageConnectors)
      .optionallyWith(
        redirectURL.map(value => RedirectURL.unwrap(value): java.lang.String)
      )(_.redirectURL)
      .optionallyWith(
        feedbackURL.map(value => FeedbackURL.unwrap(value): java.lang.String)
      )(_.feedbackURL)
      .optionallyWith(
        userSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userSettings)
      .optionallyWith(applicationSettings.map(value => value.buildAwsValue()))(
        _.applicationSettings
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        accessEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessEndpoints)
      .optionallyWith(
        embedHostDomains.map(value =>
          value.map { item =>
            EmbedHostDomain.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.embedHostDomains)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.CreateStackRequest.ReadOnly =
    zio.aws.appstream.model.CreateStackRequest.wrap(buildAwsValue())
}
object CreateStackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CreateStackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.CreateStackRequest =
      zio.aws.appstream.model.CreateStackRequest(
        name,
        description.map(value => value),
        displayName.map(value => value),
        storageConnectors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        redirectURL.map(value => value),
        feedbackURL.map(value => value),
        userSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        applicationSettings.map(value => value.asEditable),
        tags.map(value => value),
        accessEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        embedHostDomains.map(value => value)
      )
    def name: Name
    def description: Option[Description]
    def displayName: Option[DisplayName]
    def storageConnectors
        : Option[List[zio.aws.appstream.model.StorageConnector.ReadOnly]]
    def redirectURL: Option[RedirectURL]
    def feedbackURL: Option[FeedbackURL]
    def userSettings: Option[List[zio.aws.appstream.model.UserSetting.ReadOnly]]
    def applicationSettings
        : Option[zio.aws.appstream.model.ApplicationSettings.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def accessEndpoints
        : Option[List[zio.aws.appstream.model.AccessEndpoint.ReadOnly]]
    def embedHostDomains: Option[List[EmbedHostDomain]]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getStorageConnectors: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.StorageConnector.ReadOnly
    ]] = AwsError.unwrapOptionField("storageConnectors", storageConnectors)
    def getRedirectURL: ZIO[Any, AwsError, RedirectURL] =
      AwsError.unwrapOptionField("redirectURL", redirectURL)
    def getFeedbackURL: ZIO[Any, AwsError, FeedbackURL] =
      AwsError.unwrapOptionField("feedbackURL", feedbackURL)
    def getUserSettings: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.UserSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("userSettings", userSettings)
    def getApplicationSettings: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.ApplicationSettings.ReadOnly
    ] = AwsError.unwrapOptionField("applicationSettings", applicationSettings)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAccessEndpoints: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.AccessEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("accessEndpoints", accessEndpoints)
    def getEmbedHostDomains: ZIO[Any, AwsError, List[EmbedHostDomain]] =
      AwsError.unwrapOptionField("embedHostDomains", embedHostDomains)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CreateStackRequest
  ) extends zio.aws.appstream.model.CreateStackRequest.ReadOnly {
    override val name: Name =
      zio.aws.appstream.model.primitives.Name(impl.name())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.appstream.model.primitives.Description(value))
    override val displayName: Option[DisplayName] = scala
      .Option(impl.displayName())
      .map(value => zio.aws.appstream.model.primitives.DisplayName(value))
    override val storageConnectors
        : Option[List[zio.aws.appstream.model.StorageConnector.ReadOnly]] =
      scala
        .Option(impl.storageConnectors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.StorageConnector.wrap(item)
          }.toList
        )
    override val redirectURL: Option[RedirectURL] = scala
      .Option(impl.redirectURL())
      .map(value => zio.aws.appstream.model.primitives.RedirectURL(value))
    override val feedbackURL: Option[FeedbackURL] = scala
      .Option(impl.feedbackURL())
      .map(value => zio.aws.appstream.model.primitives.FeedbackURL(value))
    override val userSettings
        : Option[List[zio.aws.appstream.model.UserSetting.ReadOnly]] = scala
      .Option(impl.userSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.UserSetting.wrap(item)
        }.toList
      )
    override val applicationSettings
        : Option[zio.aws.appstream.model.ApplicationSettings.ReadOnly] = scala
      .Option(impl.applicationSettings())
      .map(value => zio.aws.appstream.model.ApplicationSettings.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appstream.model.primitives
              .TagKey(key) -> zio.aws.appstream.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val accessEndpoints
        : Option[List[zio.aws.appstream.model.AccessEndpoint.ReadOnly]] = scala
      .Option(impl.accessEndpoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.AccessEndpoint.wrap(item)
        }.toList
      )
    override val embedHostDomains: Option[List[EmbedHostDomain]] = scala
      .Option(impl.embedHostDomains())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.primitives.EmbedHostDomain(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CreateStackRequest
  ): zio.aws.appstream.model.CreateStackRequest.ReadOnly = new Wrapper(impl)
}
