package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{Timestamp, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Application(
    name: Option[String] = None,
    displayName: Option[String] = None,
    iconURL: Option[String] = None,
    launchPath: Option[String] = None,
    launchParameters: Option[String] = None,
    enabled: Option[Boolean] = None,
    metadata: Option[Map[String, String]] = None,
    workingDirectory: Option[String] = None,
    description: Option[String] = None,
    arn: Option[Arn] = None,
    appBlockArn: Option[Arn] = None,
    iconS3Location: Option[zio.aws.appstream.model.S3Location] = None,
    platforms: Option[Iterable[zio.aws.appstream.model.PlatformType]] = None,
    instanceFamilies: Option[Iterable[String]] = None,
    createdTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.Application = {
    import Application.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.Application
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(displayName.map(value => value: java.lang.String))(
        _.displayName
      )
      .optionallyWith(iconURL.map(value => value: java.lang.String))(_.iconURL)
      .optionallyWith(launchPath.map(value => value: java.lang.String))(
        _.launchPath
      )
      .optionallyWith(launchParameters.map(value => value: java.lang.String))(
        _.launchParameters
      )
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.metadata)
      .optionallyWith(workingDirectory.map(value => value: java.lang.String))(
        _.workingDirectory
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        appBlockArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.appBlockArn)
      .optionallyWith(iconS3Location.map(value => value.buildAwsValue()))(
        _.iconS3Location
      )
      .optionallyWith(
        platforms.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.platformsWithStrings)
      .optionallyWith(
        instanceFamilies.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.instanceFamilies)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.Application.ReadOnly =
    zio.aws.appstream.model.Application.wrap(buildAwsValue())
}
object Application {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.Application
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.Application =
      zio.aws.appstream.model.Application(
        name.map(value => value),
        displayName.map(value => value),
        iconURL.map(value => value),
        launchPath.map(value => value),
        launchParameters.map(value => value),
        enabled.map(value => value),
        metadata.map(value => value),
        workingDirectory.map(value => value),
        description.map(value => value),
        arn.map(value => value),
        appBlockArn.map(value => value),
        iconS3Location.map(value => value.asEditable),
        platforms.map(value => value),
        instanceFamilies.map(value => value),
        createdTime.map(value => value)
      )
    def name: Option[String]
    def displayName: Option[String]
    def iconURL: Option[String]
    def launchPath: Option[String]
    def launchParameters: Option[String]
    def enabled: Option[Boolean]
    def metadata: Option[Map[String, String]]
    def workingDirectory: Option[String]
    def description: Option[String]
    def arn: Option[Arn]
    def appBlockArn: Option[Arn]
    def iconS3Location: Option[zio.aws.appstream.model.S3Location.ReadOnly]
    def platforms: Option[List[zio.aws.appstream.model.PlatformType]]
    def instanceFamilies: Option[List[String]]
    def createdTime: Option[Timestamp]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDisplayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getIconURL: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("iconURL", iconURL)
    def getLaunchPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchPath", launchPath)
    def getLaunchParameters: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchParameters", launchParameters)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getMetadata: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getWorkingDirectory: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("workingDirectory", workingDirectory)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getAppBlockArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("appBlockArn", appBlockArn)
    def getIconS3Location
        : ZIO[Any, AwsError, zio.aws.appstream.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("iconS3Location", iconS3Location)
    def getPlatforms
        : ZIO[Any, AwsError, List[zio.aws.appstream.model.PlatformType]] =
      AwsError.unwrapOptionField("platforms", platforms)
    def getInstanceFamilies: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("instanceFamilies", instanceFamilies)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.Application
  ) extends zio.aws.appstream.model.Application.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val displayName: Option[String] =
      scala.Option(impl.displayName()).map(value => value: String)
    override val iconURL: Option[String] =
      scala.Option(impl.iconURL()).map(value => value: String)
    override val launchPath: Option[String] =
      scala.Option(impl.launchPath()).map(value => value: String)
    override val launchParameters: Option[String] =
      scala.Option(impl.launchParameters()).map(value => value: String)
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
    override val metadata: Option[Map[String, String]] = scala
      .Option(impl.metadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val workingDirectory: Option[String] =
      scala.Option(impl.workingDirectory()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val appBlockArn: Option[Arn] = scala
      .Option(impl.appBlockArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val iconS3Location
        : Option[zio.aws.appstream.model.S3Location.ReadOnly] = scala
      .Option(impl.iconS3Location())
      .map(value => zio.aws.appstream.model.S3Location.wrap(value))
    override val platforms: Option[List[zio.aws.appstream.model.PlatformType]] =
      scala
        .Option(impl.platforms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.PlatformType.wrap(item)
          }.toList
        )
    override val instanceFamilies: Option[List[String]] = scala
      .Option(impl.instanceFamilies())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val createdTime: Option[Timestamp] = scala
      .Option(impl.createdTime())
      .map(value => zio.aws.appstream.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.Application
  ): zio.aws.appstream.model.Application.ReadOnly = new Wrapper(impl)
}
