package zio.aws.apprunner.model
import scala.jdk.CollectionConverters.*
sealed trait ProviderType {
  def unwrap: software.amazon.awssdk.services.apprunner.model.ProviderType
}
object ProviderType {
  def wrap(
      value: software.amazon.awssdk.services.apprunner.model.ProviderType
  ): zio.aws.apprunner.model.ProviderType = value match {
    case software.amazon.awssdk.services.apprunner.model.ProviderType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apprunner.model.ProviderType.GITHUB =>
      val r = GITHUB
      r
    case software.amazon.awssdk.services.apprunner.model.ProviderType.BITBUCKET =>
      val r = BITBUCKET
      r
  }
  case object unknownToSdkVersion extends zio.aws.apprunner.model.ProviderType {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.ProviderType =
      software.amazon.awssdk.services.apprunner.model.ProviderType.UNKNOWN_TO_SDK_VERSION
  }
  case object GITHUB extends zio.aws.apprunner.model.ProviderType {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.ProviderType =
      software.amazon.awssdk.services.apprunner.model.ProviderType.GITHUB
  }
  case object BITBUCKET extends zio.aws.apprunner.model.ProviderType {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.ProviderType =
      software.amazon.awssdk.services.apprunner.model.ProviderType.BITBUCKET
  }
}
