package zio.aws.apprunner.model
import scala.jdk.CollectionConverters.*
sealed trait IpAddressType {
  def unwrap: software.amazon.awssdk.services.apprunner.model.IpAddressType
}
object IpAddressType {
  def wrap(
      value: software.amazon.awssdk.services.apprunner.model.IpAddressType
  ): zio.aws.apprunner.model.IpAddressType = value match {
    case software.amazon.awssdk.services.apprunner.model.IpAddressType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apprunner.model.IpAddressType.IPV4 =>
      val r = IPV4
      r
    case software.amazon.awssdk.services.apprunner.model.IpAddressType.DUAL_STACK =>
      val r = DUAL_STACK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apprunner.model.IpAddressType {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.IpAddressType =
      software.amazon.awssdk.services.apprunner.model.IpAddressType.UNKNOWN_TO_SDK_VERSION
  }
  case object IPV4 extends zio.aws.apprunner.model.IpAddressType {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.IpAddressType =
      software.amazon.awssdk.services.apprunner.model.IpAddressType.IPV4
  }
  case object DUAL_STACK extends zio.aws.apprunner.model.IpAddressType {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.IpAddressType =
      software.amazon.awssdk.services.apprunner.model.IpAddressType.DUAL_STACK
  }
}
