package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.UUID
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateServiceResponse(
    service: zio.aws.apprunner.model.Service,
    operationId: UUID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.UpdateServiceResponse = {
    import UpdateServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.UpdateServiceResponse
      .builder()
      .service(service.buildAwsValue())
      .operationId(UUID.unwrap(operationId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.UpdateServiceResponse.ReadOnly =
    zio.aws.apprunner.model.UpdateServiceResponse.wrap(buildAwsValue())
}
object UpdateServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.UpdateServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.UpdateServiceResponse =
      zio.aws.apprunner.model
        .UpdateServiceResponse(service.asEditable, operationId)
    def service: zio.aws.apprunner.model.Service.ReadOnly
    def operationId: UUID
    def getService
        : ZIO[Any, Nothing, zio.aws.apprunner.model.Service.ReadOnly] =
      ZIO.succeed(service)
    def getOperationId: ZIO[Any, Nothing, UUID] = ZIO.succeed(operationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.UpdateServiceResponse
  ) extends zio.aws.apprunner.model.UpdateServiceResponse.ReadOnly {
    override val service: zio.aws.apprunner.model.Service.ReadOnly =
      zio.aws.apprunner.model.Service.wrap(impl.service())
    override val operationId: UUID =
      zio.aws.apprunner.model.primitives.UUID(impl.operationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.UpdateServiceResponse
  ): zio.aws.apprunner.model.UpdateServiceResponse.ReadOnly = new Wrapper(impl)
}
