package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteVpcConnectorRequest(
    vpcConnectorArn: AppRunnerResourceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.DeleteVpcConnectorRequest = {
    import DeleteVpcConnectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.DeleteVpcConnectorRequest
      .builder()
      .vpcConnectorArn(
        AppRunnerResourceArn.unwrap(vpcConnectorArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.DeleteVpcConnectorRequest.ReadOnly =
    zio.aws.apprunner.model.DeleteVpcConnectorRequest.wrap(buildAwsValue())
}
object DeleteVpcConnectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.DeleteVpcConnectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.DeleteVpcConnectorRequest =
      zio.aws.apprunner.model.DeleteVpcConnectorRequest(vpcConnectorArn)
    def vpcConnectorArn: AppRunnerResourceArn
    def getVpcConnectorArn: ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(vpcConnectorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.DeleteVpcConnectorRequest
  ) extends zio.aws.apprunner.model.DeleteVpcConnectorRequest.ReadOnly {
    override val vpcConnectorArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives
        .AppRunnerResourceArn(impl.vpcConnectorArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.DeleteVpcConnectorRequest
  ): zio.aws.apprunner.model.DeleteVpcConnectorRequest.ReadOnly = new Wrapper(
    impl
  )
}
