package zio.aws.apprunner.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CodeConfiguration(
    configurationSource: zio.aws.apprunner.model.ConfigurationSource,
    codeConfigurationValues: Optional[
      zio.aws.apprunner.model.CodeConfigurationValues
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.CodeConfiguration = {
    import CodeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.CodeConfiguration
      .builder()
      .configurationSource(configurationSource.unwrap)
      .optionallyWith(
        codeConfigurationValues.map(value => value.buildAwsValue())
      )(_.codeConfigurationValues)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.CodeConfiguration.ReadOnly =
    zio.aws.apprunner.model.CodeConfiguration.wrap(buildAwsValue())
}
object CodeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.CodeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.CodeConfiguration =
      zio.aws.apprunner.model.CodeConfiguration(
        configurationSource,
        codeConfigurationValues.map(value => value.asEditable)
      )
    def configurationSource: zio.aws.apprunner.model.ConfigurationSource
    def codeConfigurationValues
        : Optional[zio.aws.apprunner.model.CodeConfigurationValues.ReadOnly]
    def getConfigurationSource
        : ZIO[Any, Nothing, zio.aws.apprunner.model.ConfigurationSource] =
      ZIO.succeed(configurationSource)
    def getCodeConfigurationValues: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.CodeConfigurationValues.ReadOnly
    ] = AwsError.unwrapOptionField(
      "codeConfigurationValues",
      codeConfigurationValues
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.CodeConfiguration
  ) extends zio.aws.apprunner.model.CodeConfiguration.ReadOnly {
    override val configurationSource
        : zio.aws.apprunner.model.ConfigurationSource =
      zio.aws.apprunner.model.ConfigurationSource
        .wrap(impl.configurationSource())
    override val codeConfigurationValues
        : Optional[zio.aws.apprunner.model.CodeConfigurationValues.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.codeConfigurationValues())
        .map(value =>
          zio.aws.apprunner.model.CodeConfigurationValues.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.CodeConfiguration
  ): zio.aws.apprunner.model.CodeConfiguration.ReadOnly = new Wrapper(impl)
}
