package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AssociateCustomDomainResponse(
    dnsTarget: String,
    serviceArn: AppRunnerResourceArn,
    customDomain: zio.aws.apprunner.model.CustomDomain,
    vpcDNSTargets: Iterable[zio.aws.apprunner.model.VpcDNSTarget]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.AssociateCustomDomainResponse = {
    import AssociateCustomDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.AssociateCustomDomainResponse
      .builder()
      .dnsTarget(dnsTarget: java.lang.String)
      .serviceArn(AppRunnerResourceArn.unwrap(serviceArn): java.lang.String)
      .customDomain(customDomain.buildAwsValue())
      .vpcDNSTargets(vpcDNSTargets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.AssociateCustomDomainResponse.ReadOnly =
    zio.aws.apprunner.model.AssociateCustomDomainResponse.wrap(buildAwsValue())
}
object AssociateCustomDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.AssociateCustomDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.AssociateCustomDomainResponse =
      zio.aws.apprunner.model.AssociateCustomDomainResponse(
        dnsTarget,
        serviceArn,
        customDomain.asEditable,
        vpcDNSTargets.map { item =>
          item.asEditable
        }
      )
    def dnsTarget: String
    def serviceArn: AppRunnerResourceArn
    def customDomain: zio.aws.apprunner.model.CustomDomain.ReadOnly
    def vpcDNSTargets: List[zio.aws.apprunner.model.VpcDNSTarget.ReadOnly]
    def getDnsTarget: ZIO[Any, Nothing, String] = ZIO.succeed(dnsTarget)
    def getServiceArn: ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(serviceArn)
    def getCustomDomain
        : ZIO[Any, Nothing, zio.aws.apprunner.model.CustomDomain.ReadOnly] =
      ZIO.succeed(customDomain)
    def getVpcDNSTargets: ZIO[Any, Nothing, List[
      zio.aws.apprunner.model.VpcDNSTarget.ReadOnly
    ]] = ZIO.succeed(vpcDNSTargets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.AssociateCustomDomainResponse
  ) extends zio.aws.apprunner.model.AssociateCustomDomainResponse.ReadOnly {
    override val dnsTarget: String = impl.dnsTarget(): String
    override val serviceArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives.AppRunnerResourceArn(impl.serviceArn())
    override val customDomain: zio.aws.apprunner.model.CustomDomain.ReadOnly =
      zio.aws.apprunner.model.CustomDomain.wrap(impl.customDomain())
    override val vpcDNSTargets
        : List[zio.aws.apprunner.model.VpcDNSTarget.ReadOnly] = impl
      .vpcDNSTargets()
      .asScala
      .map { item =>
        zio.aws.apprunner.model.VpcDNSTarget.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.AssociateCustomDomainResponse
  ): zio.aws.apprunner.model.AssociateCustomDomainResponse.ReadOnly =
    new Wrapper(impl)
}
