package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateDefaultAutoScalingConfigurationRequest(
    autoScalingConfigurationArn: AppRunnerResourceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.UpdateDefaultAutoScalingConfigurationRequest = {
    import UpdateDefaultAutoScalingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.UpdateDefaultAutoScalingConfigurationRequest
      .builder()
      .autoScalingConfigurationArn(
        AppRunnerResourceArn.unwrap(
          autoScalingConfigurationArn
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.UpdateDefaultAutoScalingConfigurationRequest.ReadOnly =
    zio.aws.apprunner.model.UpdateDefaultAutoScalingConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateDefaultAutoScalingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.UpdateDefaultAutoScalingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.apprunner.model.UpdateDefaultAutoScalingConfigurationRequest =
      zio.aws.apprunner.model.UpdateDefaultAutoScalingConfigurationRequest(
        autoScalingConfigurationArn
      )
    def autoScalingConfigurationArn: AppRunnerResourceArn
    def getAutoScalingConfigurationArn
        : ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(autoScalingConfigurationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.UpdateDefaultAutoScalingConfigurationRequest
  ) extends zio.aws.apprunner.model.UpdateDefaultAutoScalingConfigurationRequest.ReadOnly {
    override val autoScalingConfigurationArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives
        .AppRunnerResourceArn(impl.autoScalingConfigurationArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.UpdateDefaultAutoScalingConfigurationRequest
  ): zio.aws.apprunner.model.UpdateDefaultAutoScalingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
