package zio.aws.apprunner.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.apprunner.model.primitives.{
  IsDefault,
  AutoScalingConfigurationRevision,
  HasAssociatedService,
  Timestamp,
  MinSize,
  MaxSize,
  AutoScalingConfigurationName,
  AppRunnerResourceArn,
  MaxConcurrency,
  Latest
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class AutoScalingConfiguration(
    autoScalingConfigurationArn: Optional[AppRunnerResourceArn] =
      Optional.Absent,
    autoScalingConfigurationName: Optional[AutoScalingConfigurationName] =
      Optional.Absent,
    autoScalingConfigurationRevision: Optional[
      AutoScalingConfigurationRevision
    ] = Optional.Absent,
    latest: Optional[Latest] = Optional.Absent,
    status: Optional[zio.aws.apprunner.model.AutoScalingConfigurationStatus] =
      Optional.Absent,
    maxConcurrency: Optional[MaxConcurrency] = Optional.Absent,
    minSize: Optional[MinSize] = Optional.Absent,
    maxSize: Optional[MaxSize] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    deletedAt: Optional[Timestamp] = Optional.Absent,
    hasAssociatedService: Optional[HasAssociatedService] = Optional.Absent,
    isDefault: Optional[IsDefault] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.AutoScalingConfiguration = {
    import AutoScalingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.AutoScalingConfiguration
      .builder()
      .optionallyWith(
        autoScalingConfigurationArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.autoScalingConfigurationArn)
      .optionallyWith(
        autoScalingConfigurationName.map(value =>
          AutoScalingConfigurationName.unwrap(value): java.lang.String
        )
      )(_.autoScalingConfigurationName)
      .optionallyWith(
        autoScalingConfigurationRevision.map(value =>
          AutoScalingConfigurationRevision.unwrap(value): Integer
        )
      )(_.autoScalingConfigurationRevision)
      .optionallyWith(
        latest.map(value => Latest.unwrap(value): java.lang.Boolean)
      )(_.latest)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        maxConcurrency.map(value => MaxConcurrency.unwrap(value): Integer)
      )(_.maxConcurrency)
      .optionallyWith(minSize.map(value => MinSize.unwrap(value): Integer))(
        _.minSize
      )
      .optionallyWith(maxSize.map(value => MaxSize.unwrap(value): Integer))(
        _.maxSize
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(deletedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.deletedAt
      )
      .optionallyWith(
        hasAssociatedService.map(value =>
          HasAssociatedService.unwrap(value): java.lang.Boolean
        )
      )(_.hasAssociatedService)
      .optionallyWith(
        isDefault.map(value => IsDefault.unwrap(value): java.lang.Boolean)
      )(_.isDefault)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.AutoScalingConfiguration.ReadOnly =
    zio.aws.apprunner.model.AutoScalingConfiguration.wrap(buildAwsValue())
}
object AutoScalingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.AutoScalingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.AutoScalingConfiguration =
      zio.aws.apprunner.model.AutoScalingConfiguration(
        autoScalingConfigurationArn.map(value => value),
        autoScalingConfigurationName.map(value => value),
        autoScalingConfigurationRevision.map(value => value),
        latest.map(value => value),
        status.map(value => value),
        maxConcurrency.map(value => value),
        minSize.map(value => value),
        maxSize.map(value => value),
        createdAt.map(value => value),
        deletedAt.map(value => value),
        hasAssociatedService.map(value => value),
        isDefault.map(value => value)
      )
    def autoScalingConfigurationArn: Optional[AppRunnerResourceArn]
    def autoScalingConfigurationName: Optional[AutoScalingConfigurationName]
    def autoScalingConfigurationRevision
        : Optional[AutoScalingConfigurationRevision]
    def latest: Optional[Latest]
    def status: Optional[zio.aws.apprunner.model.AutoScalingConfigurationStatus]
    def maxConcurrency: Optional[MaxConcurrency]
    def minSize: Optional[MinSize]
    def maxSize: Optional[MaxSize]
    def createdAt: Optional[Timestamp]
    def deletedAt: Optional[Timestamp]
    def hasAssociatedService: Optional[HasAssociatedService]
    def isDefault: Optional[IsDefault]
    def getAutoScalingConfigurationArn
        : ZIO[Any, AwsError, AppRunnerResourceArn] = AwsError.unwrapOptionField(
      "autoScalingConfigurationArn",
      autoScalingConfigurationArn
    )
    def getAutoScalingConfigurationName
        : ZIO[Any, AwsError, AutoScalingConfigurationName] =
      AwsError.unwrapOptionField(
        "autoScalingConfigurationName",
        autoScalingConfigurationName
      )
    def getAutoScalingConfigurationRevision
        : ZIO[Any, AwsError, AutoScalingConfigurationRevision] =
      AwsError.unwrapOptionField(
        "autoScalingConfigurationRevision",
        autoScalingConfigurationRevision
      )
    def getLatest: ZIO[Any, AwsError, Latest] =
      AwsError.unwrapOptionField("latest", latest)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.AutoScalingConfigurationStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getMaxConcurrency: ZIO[Any, AwsError, MaxConcurrency] =
      AwsError.unwrapOptionField("maxConcurrency", maxConcurrency)
    def getMinSize: ZIO[Any, AwsError, MinSize] =
      AwsError.unwrapOptionField("minSize", minSize)
    def getMaxSize: ZIO[Any, AwsError, MaxSize] =
      AwsError.unwrapOptionField("maxSize", maxSize)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDeletedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deletedAt", deletedAt)
    def getHasAssociatedService: ZIO[Any, AwsError, HasAssociatedService] =
      AwsError.unwrapOptionField("hasAssociatedService", hasAssociatedService)
    def getIsDefault: ZIO[Any, AwsError, IsDefault] =
      AwsError.unwrapOptionField("isDefault", isDefault)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.AutoScalingConfiguration
  ) extends zio.aws.apprunner.model.AutoScalingConfiguration.ReadOnly {
    override val autoScalingConfigurationArn: Optional[AppRunnerResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingConfigurationArn())
        .map(value =>
          zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
        )
    override val autoScalingConfigurationName
        : Optional[AutoScalingConfigurationName] = zio.aws.core.internal
      .optionalFromNullable(impl.autoScalingConfigurationName())
      .map(value =>
        zio.aws.apprunner.model.primitives.AutoScalingConfigurationName(value)
      )
    override val autoScalingConfigurationRevision
        : Optional[AutoScalingConfigurationRevision] = zio.aws.core.internal
      .optionalFromNullable(impl.autoScalingConfigurationRevision())
      .map(value =>
        zio.aws.apprunner.model.primitives
          .AutoScalingConfigurationRevision(value)
      )
    override val latest: Optional[Latest] = zio.aws.core.internal
      .optionalFromNullable(impl.latest())
      .map(value => zio.aws.apprunner.model.primitives.Latest(value))
    override val status
        : Optional[zio.aws.apprunner.model.AutoScalingConfigurationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.apprunner.model.AutoScalingConfigurationStatus.wrap(value)
        )
    override val maxConcurrency: Optional[MaxConcurrency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxConcurrency())
        .map(value => zio.aws.apprunner.model.primitives.MaxConcurrency(value))
    override val minSize: Optional[MinSize] = zio.aws.core.internal
      .optionalFromNullable(impl.minSize())
      .map(value => zio.aws.apprunner.model.primitives.MinSize(value))
    override val maxSize: Optional[MaxSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxSize())
      .map(value => zio.aws.apprunner.model.primitives.MaxSize(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.apprunner.model.primitives.Timestamp(value))
    override val deletedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.deletedAt())
      .map(value => zio.aws.apprunner.model.primitives.Timestamp(value))
    override val hasAssociatedService: Optional[HasAssociatedService] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hasAssociatedService())
        .map(value =>
          zio.aws.apprunner.model.primitives.HasAssociatedService(value)
        )
    override val isDefault: Optional[IsDefault] = zio.aws.core.internal
      .optionalFromNullable(impl.isDefault())
      .map(value => zio.aws.apprunner.model.primitives.IsDefault(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.AutoScalingConfiguration
  ): zio.aws.apprunner.model.AutoScalingConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
