package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PauseServiceRequest(serviceArn: AppRunnerResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.PauseServiceRequest = {
    import PauseServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.PauseServiceRequest
      .builder()
      .serviceArn(AppRunnerResourceArn.unwrap(serviceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.PauseServiceRequest.ReadOnly =
    zio.aws.apprunner.model.PauseServiceRequest.wrap(buildAwsValue())
}
object PauseServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.PauseServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.PauseServiceRequest =
      zio.aws.apprunner.model.PauseServiceRequest(serviceArn)
    def serviceArn: AppRunnerResourceArn
    def getServiceArn: ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(serviceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.PauseServiceRequest
  ) extends zio.aws.apprunner.model.PauseServiceRequest.ReadOnly {
    override val serviceArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives.AppRunnerResourceArn(impl.serviceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.PauseServiceRequest
  ): zio.aws.apprunner.model.PauseServiceRequest.ReadOnly = new Wrapper(impl)
}
