package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteVpcIngressConnectionRequest(
    vpcIngressConnectionArn: AppRunnerResourceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.DeleteVpcIngressConnectionRequest = {
    import DeleteVpcIngressConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.DeleteVpcIngressConnectionRequest
      .builder()
      .vpcIngressConnectionArn(
        AppRunnerResourceArn.unwrap(vpcIngressConnectionArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.DeleteVpcIngressConnectionRequest.ReadOnly =
    zio.aws.apprunner.model.DeleteVpcIngressConnectionRequest
      .wrap(buildAwsValue())
}
object DeleteVpcIngressConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.DeleteVpcIngressConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.DeleteVpcIngressConnectionRequest =
      zio.aws.apprunner.model
        .DeleteVpcIngressConnectionRequest(vpcIngressConnectionArn)
    def vpcIngressConnectionArn: AppRunnerResourceArn
    def getVpcIngressConnectionArn: ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(vpcIngressConnectionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.DeleteVpcIngressConnectionRequest
  ) extends zio.aws.apprunner.model.DeleteVpcIngressConnectionRequest.ReadOnly {
    override val vpcIngressConnectionArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives
        .AppRunnerResourceArn(impl.vpcIngressConnectionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.DeleteVpcIngressConnectionRequest
  ): zio.aws.apprunner.model.DeleteVpcIngressConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
