package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeAutoScalingConfigurationRequest(
    autoScalingConfigurationArn: AppRunnerResourceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.DescribeAutoScalingConfigurationRequest = {
    import DescribeAutoScalingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.DescribeAutoScalingConfigurationRequest
      .builder()
      .autoScalingConfigurationArn(
        AppRunnerResourceArn.unwrap(
          autoScalingConfigurationArn
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.DescribeAutoScalingConfigurationRequest.ReadOnly =
    zio.aws.apprunner.model.DescribeAutoScalingConfigurationRequest
      .wrap(buildAwsValue())
}
object DescribeAutoScalingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.DescribeAutoScalingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.apprunner.model.DescribeAutoScalingConfigurationRequest =
      zio.aws.apprunner.model
        .DescribeAutoScalingConfigurationRequest(autoScalingConfigurationArn)
    def autoScalingConfigurationArn: AppRunnerResourceArn
    def getAutoScalingConfigurationArn
        : ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(autoScalingConfigurationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.DescribeAutoScalingConfigurationRequest
  ) extends zio.aws.apprunner.model.DescribeAutoScalingConfigurationRequest.ReadOnly {
    override val autoScalingConfigurationArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives
        .AppRunnerResourceArn(impl.autoScalingConfigurationArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.DescribeAutoScalingConfigurationRequest
  ): zio.aws.apprunner.model.DescribeAutoScalingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
