package zio.aws.apprunner.model
import scala.jdk.CollectionConverters.*
sealed trait TracingVendor {
  def unwrap: software.amazon.awssdk.services.apprunner.model.TracingVendor
}
object TracingVendor {
  def wrap(
      value: software.amazon.awssdk.services.apprunner.model.TracingVendor
  ): zio.aws.apprunner.model.TracingVendor = value match {
    case software.amazon.awssdk.services.apprunner.model.TracingVendor.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apprunner.model.TracingVendor.AWSXRAY =>
      val r = AWSXRAY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apprunner.model.TracingVendor {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.TracingVendor =
      software.amazon.awssdk.services.apprunner.model.TracingVendor.UNKNOWN_TO_SDK_VERSION
  }
  case object AWSXRAY extends zio.aws.apprunner.model.TracingVendor {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.TracingVendor =
      software.amazon.awssdk.services.apprunner.model.TracingVendor.AWSXRAY
  }
}
