package zio.aws.apprunner.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.apprunner.model.primitives.{
  HealthCheckInterval,
  HealthCheckPath,
  HealthCheckHealthyThreshold,
  HealthCheckTimeout,
  HealthCheckUnhealthyThreshold
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class HealthCheckConfiguration(
    protocol: Optional[zio.aws.apprunner.model.HealthCheckProtocol] =
      Optional.Absent,
    path: Optional[HealthCheckPath] = Optional.Absent,
    interval: Optional[HealthCheckInterval] = Optional.Absent,
    timeout: Optional[HealthCheckTimeout] = Optional.Absent,
    healthyThreshold: Optional[HealthCheckHealthyThreshold] = Optional.Absent,
    unhealthyThreshold: Optional[HealthCheckUnhealthyThreshold] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.HealthCheckConfiguration = {
    import HealthCheckConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.HealthCheckConfiguration
      .builder()
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(
        path.map(value => HealthCheckPath.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(
        interval.map(value => HealthCheckInterval.unwrap(value): Integer)
      )(_.interval)
      .optionallyWith(
        timeout.map(value => HealthCheckTimeout.unwrap(value): Integer)
      )(_.timeout)
      .optionallyWith(
        healthyThreshold.map(value =>
          HealthCheckHealthyThreshold.unwrap(value): Integer
        )
      )(_.healthyThreshold)
      .optionallyWith(
        unhealthyThreshold.map(value =>
          HealthCheckUnhealthyThreshold.unwrap(value): Integer
        )
      )(_.unhealthyThreshold)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.HealthCheckConfiguration.ReadOnly =
    zio.aws.apprunner.model.HealthCheckConfiguration.wrap(buildAwsValue())
}
object HealthCheckConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.HealthCheckConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.HealthCheckConfiguration =
      zio.aws.apprunner.model.HealthCheckConfiguration(
        protocol.map(value => value),
        path.map(value => value),
        interval.map(value => value),
        timeout.map(value => value),
        healthyThreshold.map(value => value),
        unhealthyThreshold.map(value => value)
      )
    def protocol: Optional[zio.aws.apprunner.model.HealthCheckProtocol]
    def path: Optional[HealthCheckPath]
    def interval: Optional[HealthCheckInterval]
    def timeout: Optional[HealthCheckTimeout]
    def healthyThreshold: Optional[HealthCheckHealthyThreshold]
    def unhealthyThreshold: Optional[HealthCheckUnhealthyThreshold]
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.apprunner.model.HealthCheckProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getPath: ZIO[Any, AwsError, HealthCheckPath] =
      AwsError.unwrapOptionField("path", path)
    def getInterval: ZIO[Any, AwsError, HealthCheckInterval] =
      AwsError.unwrapOptionField("interval", interval)
    def getTimeout: ZIO[Any, AwsError, HealthCheckTimeout] =
      AwsError.unwrapOptionField("timeout", timeout)
    def getHealthyThreshold: ZIO[Any, AwsError, HealthCheckHealthyThreshold] =
      AwsError.unwrapOptionField("healthyThreshold", healthyThreshold)
    def getUnhealthyThreshold
        : ZIO[Any, AwsError, HealthCheckUnhealthyThreshold] =
      AwsError.unwrapOptionField("unhealthyThreshold", unhealthyThreshold)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.HealthCheckConfiguration
  ) extends zio.aws.apprunner.model.HealthCheckConfiguration.ReadOnly {
    override val protocol
        : Optional[zio.aws.apprunner.model.HealthCheckProtocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value => zio.aws.apprunner.model.HealthCheckProtocol.wrap(value))
    override val path: Optional[HealthCheckPath] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.apprunner.model.primitives.HealthCheckPath(value))
    override val interval: Optional[HealthCheckInterval] = zio.aws.core.internal
      .optionalFromNullable(impl.interval())
      .map(value =>
        zio.aws.apprunner.model.primitives.HealthCheckInterval(value)
      )
    override val timeout: Optional[HealthCheckTimeout] = zio.aws.core.internal
      .optionalFromNullable(impl.timeout())
      .map(value =>
        zio.aws.apprunner.model.primitives.HealthCheckTimeout(value)
      )
    override val healthyThreshold: Optional[HealthCheckHealthyThreshold] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthyThreshold())
        .map(value =>
          zio.aws.apprunner.model.primitives.HealthCheckHealthyThreshold(value)
        )
    override val unhealthyThreshold: Optional[HealthCheckUnhealthyThreshold] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unhealthyThreshold())
        .map(value =>
          zio.aws.apprunner.model.primitives
            .HealthCheckUnhealthyThreshold(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.HealthCheckConfiguration
  ): zio.aws.apprunner.model.HealthCheckConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
