package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteServiceRequest(serviceArn: AppRunnerResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.DeleteServiceRequest = {
    import DeleteServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.DeleteServiceRequest
      .builder()
      .serviceArn(AppRunnerResourceArn.unwrap(serviceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.DeleteServiceRequest.ReadOnly =
    zio.aws.apprunner.model.DeleteServiceRequest.wrap(buildAwsValue())
}
object DeleteServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.DeleteServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.DeleteServiceRequest =
      zio.aws.apprunner.model.DeleteServiceRequest(serviceArn)
    def serviceArn: AppRunnerResourceArn
    def getServiceArn: ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(serviceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.DeleteServiceRequest
  ) extends zio.aws.apprunner.model.DeleteServiceRequest.ReadOnly {
    override val serviceArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives.AppRunnerResourceArn(impl.serviceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.DeleteServiceRequest
  ): zio.aws.apprunner.model.DeleteServiceRequest.ReadOnly = new Wrapper(impl)
}
