package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeVpcIngressConnectionRequest(
    vpcIngressConnectionArn: AppRunnerResourceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.DescribeVpcIngressConnectionRequest = {
    import DescribeVpcIngressConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.DescribeVpcIngressConnectionRequest
      .builder()
      .vpcIngressConnectionArn(
        AppRunnerResourceArn.unwrap(vpcIngressConnectionArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.DescribeVpcIngressConnectionRequest.ReadOnly =
    zio.aws.apprunner.model.DescribeVpcIngressConnectionRequest
      .wrap(buildAwsValue())
}
object DescribeVpcIngressConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.DescribeVpcIngressConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.apprunner.model.DescribeVpcIngressConnectionRequest =
      zio.aws.apprunner.model
        .DescribeVpcIngressConnectionRequest(vpcIngressConnectionArn)
    def vpcIngressConnectionArn: AppRunnerResourceArn
    def getVpcIngressConnectionArn: ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(vpcIngressConnectionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.DescribeVpcIngressConnectionRequest
  ) extends zio.aws.apprunner.model.DescribeVpcIngressConnectionRequest.ReadOnly {
    override val vpcIngressConnectionArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives
        .AppRunnerResourceArn(impl.vpcIngressConnectionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.DescribeVpcIngressConnectionRequest
  ): zio.aws.apprunner.model.DescribeVpcIngressConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
