package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.UUID
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteServiceResponse(
    service: zio.aws.apprunner.model.Service,
    operationId: UUID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.DeleteServiceResponse = {
    import DeleteServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.DeleteServiceResponse
      .builder()
      .service(service.buildAwsValue())
      .operationId(UUID.unwrap(operationId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.DeleteServiceResponse.ReadOnly =
    zio.aws.apprunner.model.DeleteServiceResponse.wrap(buildAwsValue())
}
object DeleteServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.DeleteServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.DeleteServiceResponse =
      zio.aws.apprunner.model
        .DeleteServiceResponse(service.asEditable, operationId)
    def service: zio.aws.apprunner.model.Service.ReadOnly
    def operationId: UUID
    def getService
        : ZIO[Any, Nothing, zio.aws.apprunner.model.Service.ReadOnly] =
      ZIO.succeed(service)
    def getOperationId: ZIO[Any, Nothing, UUID] = ZIO.succeed(operationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.DeleteServiceResponse
  ) extends zio.aws.apprunner.model.DeleteServiceResponse.ReadOnly {
    override val service: zio.aws.apprunner.model.Service.ReadOnly =
      zio.aws.apprunner.model.Service.wrap(impl.service())
    override val operationId: UUID =
      zio.aws.apprunner.model.primitives.UUID(impl.operationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.DeleteServiceResponse
  ): zio.aws.apprunner.model.DeleteServiceResponse.ReadOnly = new Wrapper(impl)
}
