package zio.aws.apprunner.model
import scala.jdk.CollectionConverters.*
sealed trait ConnectionStatus {
  def unwrap: software.amazon.awssdk.services.apprunner.model.ConnectionStatus
}
object ConnectionStatus {
  def wrap(
      value: software.amazon.awssdk.services.apprunner.model.ConnectionStatus
  ): zio.aws.apprunner.model.ConnectionStatus = value match {
    case software.amazon.awssdk.services.apprunner.model.ConnectionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apprunner.model.ConnectionStatus.PENDING_HANDSHAKE =>
      val r = PENDING_HANDSHAKE
      r
    case software.amazon.awssdk.services.apprunner.model.ConnectionStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.apprunner.model.ConnectionStatus.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.apprunner.model.ConnectionStatus.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apprunner.model.ConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.ConnectionStatus =
      software.amazon.awssdk.services.apprunner.model.ConnectionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING_HANDSHAKE
      extends zio.aws.apprunner.model.ConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.ConnectionStatus =
      software.amazon.awssdk.services.apprunner.model.ConnectionStatus.PENDING_HANDSHAKE
  }
  case object AVAILABLE extends zio.aws.apprunner.model.ConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.ConnectionStatus =
      software.amazon.awssdk.services.apprunner.model.ConnectionStatus.AVAILABLE
  }
  case object ERROR extends zio.aws.apprunner.model.ConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.ConnectionStatus =
      software.amazon.awssdk.services.apprunner.model.ConnectionStatus.ERROR
  }
  case object DELETED extends zio.aws.apprunner.model.ConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.ConnectionStatus =
      software.amazon.awssdk.services.apprunner.model.ConnectionStatus.DELETED
  }
}
