package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.{RoleArn, AppRunnerResourceArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AuthenticationConfiguration(
    connectionArn: Optional[AppRunnerResourceArn] = Optional.Absent,
    accessRoleArn: Optional[RoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.AuthenticationConfiguration = {
    import AuthenticationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.AuthenticationConfiguration
      .builder()
      .optionallyWith(
        connectionArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.connectionArn)
      .optionallyWith(
        accessRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.accessRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.AuthenticationConfiguration.ReadOnly =
    zio.aws.apprunner.model.AuthenticationConfiguration.wrap(buildAwsValue())
}
object AuthenticationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.AuthenticationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.AuthenticationConfiguration =
      zio.aws.apprunner.model.AuthenticationConfiguration(
        connectionArn.map(value => value),
        accessRoleArn.map(value => value)
      )
    def connectionArn: Optional[AppRunnerResourceArn]
    def accessRoleArn: Optional[RoleArn]
    def getConnectionArn: ZIO[Any, AwsError, AppRunnerResourceArn] =
      AwsError.unwrapOptionField("connectionArn", connectionArn)
    def getAccessRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("accessRoleArn", accessRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.AuthenticationConfiguration
  ) extends zio.aws.apprunner.model.AuthenticationConfiguration.ReadOnly {
    override val connectionArn: Optional[AppRunnerResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionArn())
        .map(value =>
          zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
        )
    override val accessRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.accessRoleArn())
      .map(value => zio.aws.apprunner.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.AuthenticationConfiguration
  ): zio.aws.apprunner.model.AuthenticationConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
