package zio.aws.apprunner
import zio.aws.apprunner.model.DescribeCustomDomainsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.apprunner.model.{
  CreateObservabilityConfigurationRequest,
  DescribeVpcConnectorRequest,
  ListVpcIngressConnectionsRequest,
  StartDeploymentRequest,
  DeleteServiceRequest,
  CreateConnectionRequest,
  ListServicesForAutoScalingConfigurationRequest,
  CreateAutoScalingConfigurationRequest,
  ListVpcConnectorsRequest,
  ListTagsForResourceRequest,
  CreateVpcConnectorRequest,
  DeleteVpcConnectorRequest,
  DisassociateCustomDomainRequest,
  ListAutoScalingConfigurationsRequest,
  DeleteConnectionRequest,
  CreateServiceRequest,
  DeleteObservabilityConfigurationRequest,
  DescribeCustomDomainsRequest,
  UpdateDefaultAutoScalingConfigurationRequest,
  DescribeServiceRequest,
  AssociateCustomDomainRequest,
  PauseServiceRequest,
  UntagResourceRequest,
  DescribeAutoScalingConfigurationRequest,
  DeleteAutoScalingConfigurationRequest,
  ListServicesRequest,
  DescribeVpcIngressConnectionRequest,
  ListConnectionsRequest,
  UpdateVpcIngressConnectionRequest,
  ListObservabilityConfigurationsRequest,
  UpdateServiceRequest,
  ResumeServiceRequest,
  ListOperationsRequest,
  CreateVpcIngressConnectionRequest,
  DeleteVpcIngressConnectionRequest,
  TagResourceRequest,
  DescribeObservabilityConfigurationRequest
}
import zio.aws.core.AwsError
import software.amazon.awssdk.services.apprunner.AppRunnerAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.stream.ZStream
object AppRunnerMock extends Mock[AppRunner] {
  object UpdateDefaultAutoScalingConfiguration
      extends Effect[
        UpdateDefaultAutoScalingConfigurationRequest,
        AwsError,
        zio.aws.apprunner.model.UpdateDefaultAutoScalingConfigurationResponse.ReadOnly
      ]
  object UpdateVpcIngressConnection
      extends Effect[
        UpdateVpcIngressConnectionRequest,
        AwsError,
        zio.aws.apprunner.model.UpdateVpcIngressConnectionResponse.ReadOnly
      ]
  object ListVpcConnectors
      extends Stream[
        ListVpcConnectorsRequest,
        AwsError,
        zio.aws.apprunner.model.VpcConnector.ReadOnly
      ]
  object ListVpcConnectorsPaginated
      extends Effect[
        ListVpcConnectorsRequest,
        AwsError,
        zio.aws.apprunner.model.ListVpcConnectorsResponse.ReadOnly
      ]
  object DescribeVpcConnector
      extends Effect[
        DescribeVpcConnectorRequest,
        AwsError,
        zio.aws.apprunner.model.DescribeVpcConnectorResponse.ReadOnly
      ]
  object ResumeService
      extends Effect[
        ResumeServiceRequest,
        AwsError,
        zio.aws.apprunner.model.ResumeServiceResponse.ReadOnly
      ]
  object AssociateCustomDomain
      extends Effect[
        AssociateCustomDomainRequest,
        AwsError,
        zio.aws.apprunner.model.AssociateCustomDomainResponse.ReadOnly
      ]
  object CreateService
      extends Effect[
        CreateServiceRequest,
        AwsError,
        zio.aws.apprunner.model.CreateServiceResponse.ReadOnly
      ]
  object ListServicesForAutoScalingConfiguration
      extends Stream[
        ListServicesForAutoScalingConfigurationRequest,
        AwsError,
        AppRunnerResourceArn
      ]
  object ListServicesForAutoScalingConfigurationPaginated
      extends Effect[
        ListServicesForAutoScalingConfigurationRequest,
        AwsError,
        zio.aws.apprunner.model.ListServicesForAutoScalingConfigurationResponse.ReadOnly
      ]
  object CreateVpcConnector
      extends Effect[
        CreateVpcConnectorRequest,
        AwsError,
        zio.aws.apprunner.model.CreateVpcConnectorResponse.ReadOnly
      ]
  object CreateConnection
      extends Effect[
        CreateConnectionRequest,
        AwsError,
        zio.aws.apprunner.model.CreateConnectionResponse.ReadOnly
      ]
  object CreateAutoScalingConfiguration
      extends Effect[
        CreateAutoScalingConfigurationRequest,
        AwsError,
        zio.aws.apprunner.model.CreateAutoScalingConfigurationResponse.ReadOnly
      ]
  object DeleteVpcIngressConnection
      extends Effect[
        DeleteVpcIngressConnectionRequest,
        AwsError,
        zio.aws.apprunner.model.DeleteVpcIngressConnectionResponse.ReadOnly
      ]
  object DeleteService
      extends Effect[
        DeleteServiceRequest,
        AwsError,
        zio.aws.apprunner.model.DeleteServiceResponse.ReadOnly
      ]
  object ListServices
      extends Stream[
        ListServicesRequest,
        AwsError,
        zio.aws.apprunner.model.ServiceSummary.ReadOnly
      ]
  object ListServicesPaginated
      extends Effect[
        ListServicesRequest,
        AwsError,
        zio.aws.apprunner.model.ListServicesResponse.ReadOnly
      ]
  object DescribeCustomDomains
      extends Effect[DescribeCustomDomainsRequest, AwsError, ReadOnly]
  object ListConnections
      extends Stream[
        ListConnectionsRequest,
        AwsError,
        zio.aws.apprunner.model.ConnectionSummary.ReadOnly
      ]
  object ListConnectionsPaginated
      extends Effect[
        ListConnectionsRequest,
        AwsError,
        zio.aws.apprunner.model.ListConnectionsResponse.ReadOnly
      ]
  object ListOperations
      extends Stream[
        ListOperationsRequest,
        AwsError,
        zio.aws.apprunner.model.OperationSummary.ReadOnly
      ]
  object ListOperationsPaginated
      extends Effect[
        ListOperationsRequest,
        AwsError,
        zio.aws.apprunner.model.ListOperationsResponse.ReadOnly
      ]
  object DeleteAutoScalingConfiguration
      extends Effect[
        DeleteAutoScalingConfigurationRequest,
        AwsError,
        zio.aws.apprunner.model.DeleteAutoScalingConfigurationResponse.ReadOnly
      ]
  object DeleteObservabilityConfiguration
      extends Effect[
        DeleteObservabilityConfigurationRequest,
        AwsError,
        zio.aws.apprunner.model.DeleteObservabilityConfigurationResponse.ReadOnly
      ]
  object PauseService
      extends Effect[
        PauseServiceRequest,
        AwsError,
        zio.aws.apprunner.model.PauseServiceResponse.ReadOnly
      ]
  object ListVpcIngressConnections
      extends Stream[
        ListVpcIngressConnectionsRequest,
        AwsError,
        zio.aws.apprunner.model.VpcIngressConnectionSummary.ReadOnly
      ]
  object ListVpcIngressConnectionsPaginated
      extends Effect[
        ListVpcIngressConnectionsRequest,
        AwsError,
        zio.aws.apprunner.model.ListVpcIngressConnectionsResponse.ReadOnly
      ]
  object DescribeVpcIngressConnection
      extends Effect[
        DescribeVpcIngressConnectionRequest,
        AwsError,
        zio.aws.apprunner.model.DescribeVpcIngressConnectionResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.apprunner.model.UntagResourceResponse.ReadOnly
      ]
  object CreateVpcIngressConnection
      extends Effect[
        CreateVpcIngressConnectionRequest,
        AwsError,
        zio.aws.apprunner.model.CreateVpcIngressConnectionResponse.ReadOnly
      ]
  object ListAutoScalingConfigurations
      extends Stream[
        ListAutoScalingConfigurationsRequest,
        AwsError,
        zio.aws.apprunner.model.AutoScalingConfigurationSummary.ReadOnly
      ]
  object ListAutoScalingConfigurationsPaginated
      extends Effect[
        ListAutoScalingConfigurationsRequest,
        AwsError,
        zio.aws.apprunner.model.ListAutoScalingConfigurationsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.apprunner.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DeleteConnection
      extends Effect[
        DeleteConnectionRequest,
        AwsError,
        zio.aws.apprunner.model.DeleteConnectionResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.apprunner.model.TagResourceResponse.ReadOnly
      ]
  object UpdateService
      extends Effect[
        UpdateServiceRequest,
        AwsError,
        zio.aws.apprunner.model.UpdateServiceResponse.ReadOnly
      ]
  object ListObservabilityConfigurations
      extends Stream[
        ListObservabilityConfigurationsRequest,
        AwsError,
        zio.aws.apprunner.model.ObservabilityConfigurationSummary.ReadOnly
      ]
  object ListObservabilityConfigurationsPaginated
      extends Effect[
        ListObservabilityConfigurationsRequest,
        AwsError,
        zio.aws.apprunner.model.ListObservabilityConfigurationsResponse.ReadOnly
      ]
  object DisassociateCustomDomain
      extends Effect[
        DisassociateCustomDomainRequest,
        AwsError,
        zio.aws.apprunner.model.DisassociateCustomDomainResponse.ReadOnly
      ]
  object CreateObservabilityConfiguration
      extends Effect[
        CreateObservabilityConfigurationRequest,
        AwsError,
        zio.aws.apprunner.model.CreateObservabilityConfigurationResponse.ReadOnly
      ]
  object DeleteVpcConnector
      extends Effect[
        DeleteVpcConnectorRequest,
        AwsError,
        zio.aws.apprunner.model.DeleteVpcConnectorResponse.ReadOnly
      ]
  object DescribeService
      extends Effect[
        DescribeServiceRequest,
        AwsError,
        zio.aws.apprunner.model.DescribeServiceResponse.ReadOnly
      ]
  object DescribeAutoScalingConfiguration
      extends Effect[
        DescribeAutoScalingConfigurationRequest,
        AwsError,
        zio.aws.apprunner.model.DescribeAutoScalingConfigurationResponse.ReadOnly
      ]
  object StartDeployment
      extends Effect[
        StartDeploymentRequest,
        AwsError,
        zio.aws.apprunner.model.StartDeploymentResponse.ReadOnly
      ]
  object DescribeObservabilityConfiguration
      extends Effect[
        DescribeObservabilityConfigurationRequest,
        AwsError,
        zio.aws.apprunner.model.DescribeObservabilityConfigurationResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, AppRunner] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, AppRunner] { rts =>
        zio.ZIO.succeed {
          new AppRunner {
            val api: AppRunnerAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): AppRunner = this
            def updateDefaultAutoScalingConfiguration(
                request: UpdateDefaultAutoScalingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.UpdateDefaultAutoScalingConfigurationResponse.ReadOnly
            ] = proxy(UpdateDefaultAutoScalingConfiguration, request)
            def updateVpcIngressConnection(
                request: UpdateVpcIngressConnectionRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.UpdateVpcIngressConnectionResponse.ReadOnly
            ] = proxy(UpdateVpcIngressConnection, request)
            def listVpcConnectors(request: ListVpcConnectorsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.apprunner.model.VpcConnector.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListVpcConnectors, request)
                }
                .getOrThrowFiberFailure()
            }
            def listVpcConnectorsPaginated(
                request: ListVpcConnectorsRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.ListVpcConnectorsResponse.ReadOnly
            ] = proxy(ListVpcConnectorsPaginated, request)
            def describeVpcConnector(request: DescribeVpcConnectorRequest): IO[
              AwsError,
              zio.aws.apprunner.model.DescribeVpcConnectorResponse.ReadOnly
            ] = proxy(DescribeVpcConnector, request)
            def resumeService(request: ResumeServiceRequest): IO[
              AwsError,
              zio.aws.apprunner.model.ResumeServiceResponse.ReadOnly
            ] = proxy(ResumeService, request)
            def associateCustomDomain(
                request: AssociateCustomDomainRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.AssociateCustomDomainResponse.ReadOnly
            ] = proxy(AssociateCustomDomain, request)
            def createService(request: CreateServiceRequest): IO[
              AwsError,
              zio.aws.apprunner.model.CreateServiceResponse.ReadOnly
            ] = proxy(CreateService, request)
            def listServicesForAutoScalingConfiguration(
                request: ListServicesForAutoScalingConfigurationRequest
            ): ZStream[Any, AwsError, AppRunnerResourceArn] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListServicesForAutoScalingConfiguration, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listServicesForAutoScalingConfigurationPaginated(
                request: ListServicesForAutoScalingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.ListServicesForAutoScalingConfigurationResponse.ReadOnly
            ] = proxy(ListServicesForAutoScalingConfigurationPaginated, request)
            def createVpcConnector(request: CreateVpcConnectorRequest): IO[
              AwsError,
              zio.aws.apprunner.model.CreateVpcConnectorResponse.ReadOnly
            ] = proxy(CreateVpcConnector, request)
            def createConnection(request: CreateConnectionRequest): IO[
              AwsError,
              zio.aws.apprunner.model.CreateConnectionResponse.ReadOnly
            ] = proxy(CreateConnection, request)
            def createAutoScalingConfiguration(
                request: CreateAutoScalingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.CreateAutoScalingConfigurationResponse.ReadOnly
            ] = proxy(CreateAutoScalingConfiguration, request)
            def deleteVpcIngressConnection(
                request: DeleteVpcIngressConnectionRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.DeleteVpcIngressConnectionResponse.ReadOnly
            ] = proxy(DeleteVpcIngressConnection, request)
            def deleteService(request: DeleteServiceRequest): IO[
              AwsError,
              zio.aws.apprunner.model.DeleteServiceResponse.ReadOnly
            ] = proxy(DeleteService, request)
            def listServices(request: ListServicesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.apprunner.model.ServiceSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListServices, request)
                }
                .getOrThrowFiberFailure()
            }
            def listServicesPaginated(request: ListServicesRequest): IO[
              AwsError,
              zio.aws.apprunner.model.ListServicesResponse.ReadOnly
            ] = proxy(ListServicesPaginated, request)
            def describeCustomDomains(
                request: DescribeCustomDomainsRequest
            ): IO[AwsError, ReadOnly] = proxy(DescribeCustomDomains, request)
            def listConnections(request: ListConnectionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.apprunner.model.ConnectionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListConnections, request)
                }
                .getOrThrowFiberFailure()
            }
            def listConnectionsPaginated(request: ListConnectionsRequest): IO[
              AwsError,
              zio.aws.apprunner.model.ListConnectionsResponse.ReadOnly
            ] = proxy(ListConnectionsPaginated, request)
            def listOperations(request: ListOperationsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.apprunner.model.OperationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListOperations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listOperationsPaginated(request: ListOperationsRequest): IO[
              AwsError,
              zio.aws.apprunner.model.ListOperationsResponse.ReadOnly
            ] = proxy(ListOperationsPaginated, request)
            def deleteAutoScalingConfiguration(
                request: DeleteAutoScalingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.DeleteAutoScalingConfigurationResponse.ReadOnly
            ] = proxy(DeleteAutoScalingConfiguration, request)
            def deleteObservabilityConfiguration(
                request: DeleteObservabilityConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.DeleteObservabilityConfigurationResponse.ReadOnly
            ] = proxy(DeleteObservabilityConfiguration, request)
            def pauseService(request: PauseServiceRequest): IO[
              AwsError,
              zio.aws.apprunner.model.PauseServiceResponse.ReadOnly
            ] = proxy(PauseService, request)
            def listVpcIngressConnections(
                request: ListVpcIngressConnectionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.apprunner.model.VpcIngressConnectionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListVpcIngressConnections, request)
                }
                .getOrThrowFiberFailure()
            }
            def listVpcIngressConnectionsPaginated(
                request: ListVpcIngressConnectionsRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.ListVpcIngressConnectionsResponse.ReadOnly
            ] = proxy(ListVpcIngressConnectionsPaginated, request)
            def describeVpcIngressConnection(
                request: DescribeVpcIngressConnectionRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.DescribeVpcIngressConnectionResponse.ReadOnly
            ] = proxy(DescribeVpcIngressConnection, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.apprunner.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def createVpcIngressConnection(
                request: CreateVpcIngressConnectionRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.CreateVpcIngressConnectionResponse.ReadOnly
            ] = proxy(CreateVpcIngressConnection, request)
            def listAutoScalingConfigurations(
                request: ListAutoScalingConfigurationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.apprunner.model.AutoScalingConfigurationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAutoScalingConfigurations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAutoScalingConfigurationsPaginated(
                request: ListAutoScalingConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.ListAutoScalingConfigurationsResponse.ReadOnly
            ] = proxy(ListAutoScalingConfigurationsPaginated, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.apprunner.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def deleteConnection(request: DeleteConnectionRequest): IO[
              AwsError,
              zio.aws.apprunner.model.DeleteConnectionResponse.ReadOnly
            ] = proxy(DeleteConnection, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.apprunner.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def updateService(request: UpdateServiceRequest): IO[
              AwsError,
              zio.aws.apprunner.model.UpdateServiceResponse.ReadOnly
            ] = proxy(UpdateService, request)
            def listObservabilityConfigurations(
                request: ListObservabilityConfigurationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.apprunner.model.ObservabilityConfigurationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListObservabilityConfigurations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listObservabilityConfigurationsPaginated(
                request: ListObservabilityConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.ListObservabilityConfigurationsResponse.ReadOnly
            ] = proxy(ListObservabilityConfigurationsPaginated, request)
            def disassociateCustomDomain(
                request: DisassociateCustomDomainRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.DisassociateCustomDomainResponse.ReadOnly
            ] = proxy(DisassociateCustomDomain, request)
            def createObservabilityConfiguration(
                request: CreateObservabilityConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.CreateObservabilityConfigurationResponse.ReadOnly
            ] = proxy(CreateObservabilityConfiguration, request)
            def deleteVpcConnector(request: DeleteVpcConnectorRequest): IO[
              AwsError,
              zio.aws.apprunner.model.DeleteVpcConnectorResponse.ReadOnly
            ] = proxy(DeleteVpcConnector, request)
            def describeService(request: DescribeServiceRequest): IO[
              AwsError,
              zio.aws.apprunner.model.DescribeServiceResponse.ReadOnly
            ] = proxy(DescribeService, request)
            def describeAutoScalingConfiguration(
                request: DescribeAutoScalingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.DescribeAutoScalingConfigurationResponse.ReadOnly
            ] = proxy(DescribeAutoScalingConfiguration, request)
            def startDeployment(request: StartDeploymentRequest): IO[
              AwsError,
              zio.aws.apprunner.model.StartDeploymentResponse.ReadOnly
            ] = proxy(StartDeployment, request)
            def describeObservabilityConfiguration(
                request: DescribeObservabilityConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.DescribeObservabilityConfigurationResponse.ReadOnly
            ] = proxy(DescribeObservabilityConfiguration, request)
          }
        }
      }
    }
  }
}
