package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeObservabilityConfigurationRequest(
    observabilityConfigurationArn: AppRunnerResourceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.DescribeObservabilityConfigurationRequest = {
    import DescribeObservabilityConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.DescribeObservabilityConfigurationRequest
      .builder()
      .observabilityConfigurationArn(
        AppRunnerResourceArn.unwrap(
          observabilityConfigurationArn
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.DescribeObservabilityConfigurationRequest.ReadOnly =
    zio.aws.apprunner.model.DescribeObservabilityConfigurationRequest
      .wrap(buildAwsValue())
}
object DescribeObservabilityConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.DescribeObservabilityConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.apprunner.model.DescribeObservabilityConfigurationRequest =
      zio.aws.apprunner.model.DescribeObservabilityConfigurationRequest(
        observabilityConfigurationArn
      )
    def observabilityConfigurationArn: AppRunnerResourceArn
    def getObservabilityConfigurationArn
        : ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(observabilityConfigurationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.DescribeObservabilityConfigurationRequest
  ) extends zio.aws.apprunner.model.DescribeObservabilityConfigurationRequest.ReadOnly {
    override val observabilityConfigurationArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives
        .AppRunnerResourceArn(impl.observabilityConfigurationArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.DescribeObservabilityConfigurationRequest
  ): zio.aws.apprunner.model.DescribeObservabilityConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
