package zio.aws.apprunner.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.apprunner.model.primitives.{
  ASConfigMaxSize,
  ASConfigMinSize,
  ASConfigMaxConcurrency,
  AutoScalingConfigurationName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateAutoScalingConfigurationRequest(
    autoScalingConfigurationName: AutoScalingConfigurationName,
    maxConcurrency: Optional[ASConfigMaxConcurrency] = Optional.Absent,
    minSize: Optional[ASConfigMinSize] = Optional.Absent,
    maxSize: Optional[ASConfigMaxSize] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.apprunner.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.CreateAutoScalingConfigurationRequest = {
    import CreateAutoScalingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.CreateAutoScalingConfigurationRequest
      .builder()
      .autoScalingConfigurationName(
        AutoScalingConfigurationName.unwrap(
          autoScalingConfigurationName
        ): java.lang.String
      )
      .optionallyWith(
        maxConcurrency.map(value =>
          ASConfigMaxConcurrency.unwrap(value): Integer
        )
      )(_.maxConcurrency)
      .optionallyWith(
        minSize.map(value => ASConfigMinSize.unwrap(value): Integer)
      )(_.minSize)
      .optionallyWith(
        maxSize.map(value => ASConfigMaxSize.unwrap(value): Integer)
      )(_.maxSize)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.CreateAutoScalingConfigurationRequest.ReadOnly =
    zio.aws.apprunner.model.CreateAutoScalingConfigurationRequest
      .wrap(buildAwsValue())
}
object CreateAutoScalingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.CreateAutoScalingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.apprunner.model.CreateAutoScalingConfigurationRequest =
      zio.aws.apprunner.model.CreateAutoScalingConfigurationRequest(
        autoScalingConfigurationName,
        maxConcurrency.map(value => value),
        minSize.map(value => value),
        maxSize.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def autoScalingConfigurationName: AutoScalingConfigurationName
    def maxConcurrency: Optional[ASConfigMaxConcurrency]
    def minSize: Optional[ASConfigMinSize]
    def maxSize: Optional[ASConfigMaxSize]
    def tags: Optional[List[zio.aws.apprunner.model.Tag.ReadOnly]]
    def getAutoScalingConfigurationName
        : ZIO[Any, Nothing, AutoScalingConfigurationName] =
      ZIO.succeed(autoScalingConfigurationName)
    def getMaxConcurrency: ZIO[Any, AwsError, ASConfigMaxConcurrency] =
      AwsError.unwrapOptionField("maxConcurrency", maxConcurrency)
    def getMinSize: ZIO[Any, AwsError, ASConfigMinSize] =
      AwsError.unwrapOptionField("minSize", minSize)
    def getMaxSize: ZIO[Any, AwsError, ASConfigMaxSize] =
      AwsError.unwrapOptionField("maxSize", maxSize)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.apprunner.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.CreateAutoScalingConfigurationRequest
  ) extends zio.aws.apprunner.model.CreateAutoScalingConfigurationRequest.ReadOnly {
    override val autoScalingConfigurationName: AutoScalingConfigurationName =
      zio.aws.apprunner.model.primitives
        .AutoScalingConfigurationName(impl.autoScalingConfigurationName())
    override val maxConcurrency: Optional[ASConfigMaxConcurrency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxConcurrency())
        .map(value =>
          zio.aws.apprunner.model.primitives.ASConfigMaxConcurrency(value)
        )
    override val minSize: Optional[ASConfigMinSize] = zio.aws.core.internal
      .optionalFromNullable(impl.minSize())
      .map(value => zio.aws.apprunner.model.primitives.ASConfigMinSize(value))
    override val maxSize: Optional[ASConfigMaxSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxSize())
      .map(value => zio.aws.apprunner.model.primitives.ASConfigMaxSize(value))
    override val tags: Optional[List[zio.aws.apprunner.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apprunner.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.CreateAutoScalingConfigurationRequest
  ): zio.aws.apprunner.model.CreateAutoScalingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
