package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ResumeServiceRequest(serviceArn: AppRunnerResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ResumeServiceRequest = {
    import ResumeServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ResumeServiceRequest
      .builder()
      .serviceArn(AppRunnerResourceArn.unwrap(serviceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.ResumeServiceRequest.ReadOnly =
    zio.aws.apprunner.model.ResumeServiceRequest.wrap(buildAwsValue())
}
object ResumeServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ResumeServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.ResumeServiceRequest =
      zio.aws.apprunner.model.ResumeServiceRequest(serviceArn)
    def serviceArn: AppRunnerResourceArn
    def getServiceArn: ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(serviceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ResumeServiceRequest
  ) extends zio.aws.apprunner.model.ResumeServiceRequest.ReadOnly {
    override val serviceArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives.AppRunnerResourceArn(impl.serviceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ResumeServiceRequest
  ): zio.aws.apprunner.model.ResumeServiceRequest.ReadOnly = new Wrapper(impl)
}
