package zio.aws.apprunner.model
import scala.jdk.CollectionConverters.*
sealed trait EgressType {
  def unwrap: software.amazon.awssdk.services.apprunner.model.EgressType
}
object EgressType {
  def wrap(
      value: software.amazon.awssdk.services.apprunner.model.EgressType
  ): zio.aws.apprunner.model.EgressType = value match {
    case software.amazon.awssdk.services.apprunner.model.EgressType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apprunner.model.EgressType.DEFAULT =>
      val r = DEFAULT
      r
    case software.amazon.awssdk.services.apprunner.model.EgressType.VPC =>
      val r = VPC
      r
  }
  case object unknownToSdkVersion extends zio.aws.apprunner.model.EgressType {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.EgressType =
      software.amazon.awssdk.services.apprunner.model.EgressType.UNKNOWN_TO_SDK_VERSION
  }
  case object DEFAULT extends zio.aws.apprunner.model.EgressType {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.EgressType =
      software.amazon.awssdk.services.apprunner.model.EgressType.DEFAULT
  }
  case object VPC extends zio.aws.apprunner.model.EgressType {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.EgressType =
      software.amazon.awssdk.services.apprunner.model.EgressType.VPC
  }
}
