package zio.aws.apprunner.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.apprunner.model.primitives.{
  ListOperationsMaxResults,
  AppRunnerResourceArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListOperationsRequest(
    serviceArn: AppRunnerResourceArn,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[ListOperationsMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ListOperationsRequest = {
    import ListOperationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ListOperationsRequest
      .builder()
      .serviceArn(AppRunnerResourceArn.unwrap(serviceArn): java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => ListOperationsMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.ListOperationsRequest.ReadOnly =
    zio.aws.apprunner.model.ListOperationsRequest.wrap(buildAwsValue())
}
object ListOperationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ListOperationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.ListOperationsRequest =
      zio.aws.apprunner.model.ListOperationsRequest(
        serviceArn,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def serviceArn: AppRunnerResourceArn
    def nextToken: Optional[String]
    def maxResults: Optional[ListOperationsMaxResults]
    def getServiceArn: ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(serviceArn)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListOperationsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ListOperationsRequest
  ) extends zio.aws.apprunner.model.ListOperationsRequest.ReadOnly {
    override val serviceArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives.AppRunnerResourceArn(impl.serviceArn())
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[ListOperationsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.apprunner.model.primitives.ListOperationsMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ListOperationsRequest
  ): zio.aws.apprunner.model.ListOperationsRequest.ReadOnly = new Wrapper(impl)
}
