package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListVpcConnectorsResponse(
    vpcConnectors: Iterable[zio.aws.apprunner.model.VpcConnector],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ListVpcConnectorsResponse = {
    import ListVpcConnectorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ListVpcConnectorsResponse
      .builder()
      .vpcConnectors(vpcConnectors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.ListVpcConnectorsResponse.ReadOnly =
    zio.aws.apprunner.model.ListVpcConnectorsResponse.wrap(buildAwsValue())
}
object ListVpcConnectorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ListVpcConnectorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.ListVpcConnectorsResponse =
      zio.aws.apprunner.model.ListVpcConnectorsResponse(
        vpcConnectors.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def vpcConnectors: List[zio.aws.apprunner.model.VpcConnector.ReadOnly]
    def nextToken: Optional[NextToken]
    def getVpcConnectors: ZIO[Any, Nothing, List[
      zio.aws.apprunner.model.VpcConnector.ReadOnly
    ]] = ZIO.succeed(vpcConnectors)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ListVpcConnectorsResponse
  ) extends zio.aws.apprunner.model.ListVpcConnectorsResponse.ReadOnly {
    override val vpcConnectors
        : List[zio.aws.apprunner.model.VpcConnector.ReadOnly] = impl
      .vpcConnectors()
      .asScala
      .map { item =>
        zio.aws.apprunner.model.VpcConnector.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.apprunner.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ListVpcConnectorsResponse
  ): zio.aws.apprunner.model.ListVpcConnectorsResponse.ReadOnly = new Wrapper(
    impl
  )
}
