package zio.aws.apprunner
import zio.aws.apprunner.model.primitives.{
  TagKey,
  RuntimeEnvironmentVariablesValue,
  RuntimeEnvironmentVariablesKey
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.apprunner.model.primitives.VpcIngressConnectionName.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object ASConfigMaxConcurrency extends Subtype[Int]
    type ASConfigMaxConcurrency =
      zio.aws.apprunner.model.primitives.ASConfigMaxConcurrency.Type
    object ASConfigMaxSize extends Subtype[Int]
    type ASConfigMaxSize =
      zio.aws.apprunner.model.primitives.ASConfigMaxSize.Type
    object ASConfigMinSize extends Subtype[Int]
    type ASConfigMinSize =
      zio.aws.apprunner.model.primitives.ASConfigMinSize.Type
    object AppRunnerResourceArn extends Subtype[String]
    type AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives.AppRunnerResourceArn.Type
    object AutoScalingConfigurationName extends Subtype[String]
    type AutoScalingConfigurationName =
      zio.aws.apprunner.model.primitives.AutoScalingConfigurationName.Type
    object BuildCommand extends Subtype[String]
    type BuildCommand = zio.aws.apprunner.model.primitives.BuildCommand.Type
    object ConnectionName extends Subtype[String]
    type ConnectionName = zio.aws.apprunner.model.primitives.ConnectionName.Type
    object Cpu extends Subtype[String]
    type Cpu = zio.aws.apprunner.model.primitives.Cpu.Type
    object CustomerAccountId extends Subtype[String]
    type CustomerAccountId =
      zio.aws.apprunner.model.primitives.CustomerAccountId.Type
    object DescribeCustomDomainsMaxResults extends Subtype[Int]
    type DescribeCustomDomainsMaxResults =
      zio.aws.apprunner.model.primitives.DescribeCustomDomainsMaxResults.Type
    object DomainName extends Subtype[String]
    type DomainName = zio.aws.apprunner.model.primitives.DomainName.Type
    object HealthCheckHealthyThreshold extends Subtype[Int]
    type HealthCheckHealthyThreshold =
      zio.aws.apprunner.model.primitives.HealthCheckHealthyThreshold.Type
    object HealthCheckInterval extends Subtype[Int]
    type HealthCheckInterval =
      zio.aws.apprunner.model.primitives.HealthCheckInterval.Type
    object HealthCheckPath extends Subtype[String]
    type HealthCheckPath =
      zio.aws.apprunner.model.primitives.HealthCheckPath.Type
    object HealthCheckTimeout extends Subtype[Int]
    type HealthCheckTimeout =
      zio.aws.apprunner.model.primitives.HealthCheckTimeout.Type
    object HealthCheckUnhealthyThreshold extends Subtype[Int]
    type HealthCheckUnhealthyThreshold =
      zio.aws.apprunner.model.primitives.HealthCheckUnhealthyThreshold.Type
    object ImageIdentifier extends Subtype[String]
    type ImageIdentifier =
      zio.aws.apprunner.model.primitives.ImageIdentifier.Type
    type Integer = Int
    object KmsKeyArn extends Subtype[String]
    type KmsKeyArn = zio.aws.apprunner.model.primitives.KmsKeyArn.Type
    object ListOperationsMaxResults extends Subtype[Int]
    type ListOperationsMaxResults =
      zio.aws.apprunner.model.primitives.ListOperationsMaxResults.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.apprunner.model.primitives.MaxResults.Type
    object Memory extends Subtype[String]
    type Memory = zio.aws.apprunner.model.primitives.Memory.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.apprunner.model.primitives.NextToken.Type
    type NullableBoolean = Boolean
    object ObservabilityConfigurationName extends Subtype[String]
    type ObservabilityConfigurationName =
      zio.aws.apprunner.model.primitives.ObservabilityConfigurationName.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.apprunner.model.primitives.RoleArn.Type
    object RuntimeEnvironmentVariablesKey extends Subtype[String]
    type RuntimeEnvironmentVariablesKey =
      zio.aws.apprunner.model.primitives.RuntimeEnvironmentVariablesKey.Type
    object RuntimeEnvironmentVariablesValue extends Subtype[String]
    type RuntimeEnvironmentVariablesValue =
      zio.aws.apprunner.model.primitives.RuntimeEnvironmentVariablesValue.Type
    object ServiceId extends Subtype[String]
    type ServiceId = zio.aws.apprunner.model.primitives.ServiceId.Type
    object ServiceMaxResults extends Subtype[Int]
    type ServiceMaxResults =
      zio.aws.apprunner.model.primitives.ServiceMaxResults.Type
    object ServiceName extends Subtype[String]
    type ServiceName = zio.aws.apprunner.model.primitives.ServiceName.Type
    object StartCommand extends Subtype[String]
    type StartCommand = zio.aws.apprunner.model.primitives.StartCommand.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.apprunner.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.apprunner.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.apprunner.model.primitives.Timestamp.Type
    object UUID extends Subtype[String]
    type UUID = zio.aws.apprunner.model.primitives.UUID.Type
    object VpcConnectorName extends Subtype[String]
    type VpcConnectorName =
      zio.aws.apprunner.model.primitives.VpcConnectorName.Type
    object VpcIngressConnectionName extends Subtype[String]
    type VpcIngressConnectionName =
      zio.aws.apprunner.model.primitives.VpcIngressConnectionName.Type
  }
  type AutoScalingConfigurationSummaryList =
    List[zio.aws.apprunner.model.AutoScalingConfigurationSummary]
  type CertificateValidationRecordList =
    List[zio.aws.apprunner.model.CertificateValidationRecord]
  type ConnectionSummaryList = List[zio.aws.apprunner.model.ConnectionSummary]
  type CustomDomainList = List[zio.aws.apprunner.model.CustomDomain]
  type ObservabilityConfigurationSummaryList =
    List[zio.aws.apprunner.model.ObservabilityConfigurationSummary]
  type OperationSummaryList = List[zio.aws.apprunner.model.OperationSummary]
  type RuntimeEnvironmentVariables =
    Map[RuntimeEnvironmentVariablesKey, RuntimeEnvironmentVariablesValue]
  type ServiceSummaryList = List[zio.aws.apprunner.model.ServiceSummary]
  type StringList = List[String]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.apprunner.model.Tag]
  type VpcConnectors = List[zio.aws.apprunner.model.VpcConnector]
  type VpcDNSTargetList = List[zio.aws.apprunner.model.VpcDNSTarget]
  type VpcIngressConnectionSummaryList =
    List[zio.aws.apprunner.model.VpcIngressConnectionSummary]
}
