package zio.aws.apprunner.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NetworkConfiguration(
    egressConfiguration: Optional[zio.aws.apprunner.model.EgressConfiguration] =
      Optional.Absent,
    ingressConfiguration: Optional[
      zio.aws.apprunner.model.IngressConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.NetworkConfiguration = {
    import NetworkConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.NetworkConfiguration
      .builder()
      .optionallyWith(egressConfiguration.map(value => value.buildAwsValue()))(
        _.egressConfiguration
      )
      .optionallyWith(ingressConfiguration.map(value => value.buildAwsValue()))(
        _.ingressConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.NetworkConfiguration.ReadOnly =
    zio.aws.apprunner.model.NetworkConfiguration.wrap(buildAwsValue())
}
object NetworkConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.NetworkConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.NetworkConfiguration =
      zio.aws.apprunner.model.NetworkConfiguration(
        egressConfiguration.map(value => value.asEditable),
        ingressConfiguration.map(value => value.asEditable)
      )
    def egressConfiguration
        : Optional[zio.aws.apprunner.model.EgressConfiguration.ReadOnly]
    def ingressConfiguration
        : Optional[zio.aws.apprunner.model.IngressConfiguration.ReadOnly]
    def getEgressConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.EgressConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("egressConfiguration", egressConfiguration)
    def getIngressConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.IngressConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("ingressConfiguration", ingressConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.NetworkConfiguration
  ) extends zio.aws.apprunner.model.NetworkConfiguration.ReadOnly {
    override val egressConfiguration
        : Optional[zio.aws.apprunner.model.EgressConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.egressConfiguration())
        .map(value => zio.aws.apprunner.model.EgressConfiguration.wrap(value))
    override val ingressConfiguration
        : Optional[zio.aws.apprunner.model.IngressConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ingressConfiguration())
        .map(value => zio.aws.apprunner.model.IngressConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.NetworkConfiguration
  ): zio.aws.apprunner.model.NetworkConfiguration.ReadOnly = new Wrapper(impl)
}
