package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.{
  Integer,
  ObservabilityConfigurationName,
  AppRunnerResourceArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ObservabilityConfigurationSummary(
    observabilityConfigurationArn: Optional[AppRunnerResourceArn] =
      Optional.Absent,
    observabilityConfigurationName: Optional[ObservabilityConfigurationName] =
      Optional.Absent,
    observabilityConfigurationRevision: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ObservabilityConfigurationSummary = {
    import ObservabilityConfigurationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ObservabilityConfigurationSummary
      .builder()
      .optionallyWith(
        observabilityConfigurationArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.observabilityConfigurationArn)
      .optionallyWith(
        observabilityConfigurationName.map(value =>
          ObservabilityConfigurationName.unwrap(value): java.lang.String
        )
      )(_.observabilityConfigurationName)
      .optionallyWith(
        observabilityConfigurationRevision.map(value =>
          value: java.lang.Integer
        )
      )(_.observabilityConfigurationRevision)
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.ObservabilityConfigurationSummary.ReadOnly =
    zio.aws.apprunner.model.ObservabilityConfigurationSummary
      .wrap(buildAwsValue())
}
object ObservabilityConfigurationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ObservabilityConfigurationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.ObservabilityConfigurationSummary =
      zio.aws.apprunner.model.ObservabilityConfigurationSummary(
        observabilityConfigurationArn.map(value => value),
        observabilityConfigurationName.map(value => value),
        observabilityConfigurationRevision.map(value => value)
      )
    def observabilityConfigurationArn: Optional[AppRunnerResourceArn]
    def observabilityConfigurationName: Optional[ObservabilityConfigurationName]
    def observabilityConfigurationRevision: Optional[Integer]
    def getObservabilityConfigurationArn
        : ZIO[Any, AwsError, AppRunnerResourceArn] = AwsError.unwrapOptionField(
      "observabilityConfigurationArn",
      observabilityConfigurationArn
    )
    def getObservabilityConfigurationName
        : ZIO[Any, AwsError, ObservabilityConfigurationName] =
      AwsError.unwrapOptionField(
        "observabilityConfigurationName",
        observabilityConfigurationName
      )
    def getObservabilityConfigurationRevision: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "observabilityConfigurationRevision",
        observabilityConfigurationRevision
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ObservabilityConfigurationSummary
  ) extends zio.aws.apprunner.model.ObservabilityConfigurationSummary.ReadOnly {
    override val observabilityConfigurationArn: Optional[AppRunnerResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.observabilityConfigurationArn())
        .map(value =>
          zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
        )
    override val observabilityConfigurationName
        : Optional[ObservabilityConfigurationName] = zio.aws.core.internal
      .optionalFromNullable(impl.observabilityConfigurationName())
      .map(value =>
        zio.aws.apprunner.model.primitives.ObservabilityConfigurationName(value)
      )
    override val observabilityConfigurationRevision: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.observabilityConfigurationRevision())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ObservabilityConfigurationSummary
  ): zio.aws.apprunner.model.ObservabilityConfigurationSummary.ReadOnly =
    new Wrapper(impl)
}
