package zio.aws.apprunner.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeServiceResponse(
    service: zio.aws.apprunner.model.Service
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.DescribeServiceResponse = {
    import DescribeServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.DescribeServiceResponse
      .builder()
      .service(service.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.DescribeServiceResponse.ReadOnly =
    zio.aws.apprunner.model.DescribeServiceResponse.wrap(buildAwsValue())
}
object DescribeServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.DescribeServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.DescribeServiceResponse =
      zio.aws.apprunner.model.DescribeServiceResponse(service.asEditable)
    def service: zio.aws.apprunner.model.Service.ReadOnly
    def getService
        : ZIO[Any, Nothing, zio.aws.apprunner.model.Service.ReadOnly] =
      ZIO.succeed(service)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.DescribeServiceResponse
  ) extends zio.aws.apprunner.model.DescribeServiceResponse.ReadOnly {
    override val service: zio.aws.apprunner.model.Service.ReadOnly =
      zio.aws.apprunner.model.Service.wrap(impl.service())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.DescribeServiceResponse
  ): zio.aws.apprunner.model.DescribeServiceResponse.ReadOnly = new Wrapper(
    impl
  )
}
