package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DisassociateCustomDomainResponse(
    dnsTarget: String,
    serviceArn: AppRunnerResourceArn,
    customDomain: zio.aws.apprunner.model.CustomDomain,
    vpcDNSTargets: Iterable[zio.aws.apprunner.model.VpcDNSTarget]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.DisassociateCustomDomainResponse = {
    import DisassociateCustomDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.DisassociateCustomDomainResponse
      .builder()
      .dnsTarget(dnsTarget: java.lang.String)
      .serviceArn(AppRunnerResourceArn.unwrap(serviceArn): java.lang.String)
      .customDomain(customDomain.buildAwsValue())
      .vpcDNSTargets(vpcDNSTargets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.DisassociateCustomDomainResponse.ReadOnly =
    zio.aws.apprunner.model.DisassociateCustomDomainResponse
      .wrap(buildAwsValue())
}
object DisassociateCustomDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.DisassociateCustomDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.DisassociateCustomDomainResponse =
      zio.aws.apprunner.model.DisassociateCustomDomainResponse(
        dnsTarget,
        serviceArn,
        customDomain.asEditable,
        vpcDNSTargets.map { item =>
          item.asEditable
        }
      )
    def dnsTarget: String
    def serviceArn: AppRunnerResourceArn
    def customDomain: zio.aws.apprunner.model.CustomDomain.ReadOnly
    def vpcDNSTargets: List[zio.aws.apprunner.model.VpcDNSTarget.ReadOnly]
    def getDnsTarget: ZIO[Any, Nothing, String] = ZIO.succeed(dnsTarget)
    def getServiceArn: ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(serviceArn)
    def getCustomDomain
        : ZIO[Any, Nothing, zio.aws.apprunner.model.CustomDomain.ReadOnly] =
      ZIO.succeed(customDomain)
    def getVpcDNSTargets: ZIO[Any, Nothing, List[
      zio.aws.apprunner.model.VpcDNSTarget.ReadOnly
    ]] = ZIO.succeed(vpcDNSTargets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.DisassociateCustomDomainResponse
  ) extends zio.aws.apprunner.model.DisassociateCustomDomainResponse.ReadOnly {
    override val dnsTarget: String = impl.dnsTarget(): String
    override val serviceArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives.AppRunnerResourceArn(impl.serviceArn())
    override val customDomain: zio.aws.apprunner.model.CustomDomain.ReadOnly =
      zio.aws.apprunner.model.CustomDomain.wrap(impl.customDomain())
    override val vpcDNSTargets
        : List[zio.aws.apprunner.model.VpcDNSTarget.ReadOnly] = impl
      .vpcDNSTargets()
      .asScala
      .map { item =>
        zio.aws.apprunner.model.VpcDNSTarget.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.DisassociateCustomDomainResponse
  ): zio.aws.apprunner.model.DisassociateCustomDomainResponse.ReadOnly =
    new Wrapper(impl)
}
