package zio.aws.apprunner.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.apprunner.model.primitives.{
  Timestamp,
  Integer,
  AppRunnerResourceArn,
  VpcConnectorName
}
import scala.jdk.CollectionConverters.*
final case class VpcConnector(
    vpcConnectorName: Optional[VpcConnectorName] = Optional.Absent,
    vpcConnectorArn: Optional[AppRunnerResourceArn] = Optional.Absent,
    vpcConnectorRevision: Optional[Integer] = Optional.Absent,
    subnets: Optional[Iterable[String]] = Optional.Absent,
    securityGroups: Optional[Iterable[String]] = Optional.Absent,
    status: Optional[zio.aws.apprunner.model.VpcConnectorStatus] =
      Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    deletedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.VpcConnector = {
    import VpcConnector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.VpcConnector
      .builder()
      .optionallyWith(
        vpcConnectorName.map(value =>
          VpcConnectorName.unwrap(value): java.lang.String
        )
      )(_.vpcConnectorName)
      .optionallyWith(
        vpcConnectorArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.vpcConnectorArn)
      .optionallyWith(
        vpcConnectorRevision.map(value => value: java.lang.Integer)
      )(_.vpcConnectorRevision)
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(deletedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.deletedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.VpcConnector.ReadOnly =
    zio.aws.apprunner.model.VpcConnector.wrap(buildAwsValue())
}
object VpcConnector {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.VpcConnector
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.VpcConnector =
      zio.aws.apprunner.model.VpcConnector(
        vpcConnectorName.map(value => value),
        vpcConnectorArn.map(value => value),
        vpcConnectorRevision.map(value => value),
        subnets.map(value => value),
        securityGroups.map(value => value),
        status.map(value => value),
        createdAt.map(value => value),
        deletedAt.map(value => value)
      )
    def vpcConnectorName: Optional[VpcConnectorName]
    def vpcConnectorArn: Optional[AppRunnerResourceArn]
    def vpcConnectorRevision: Optional[Integer]
    def subnets: Optional[List[String]]
    def securityGroups: Optional[List[String]]
    def status: Optional[zio.aws.apprunner.model.VpcConnectorStatus]
    def createdAt: Optional[Timestamp]
    def deletedAt: Optional[Timestamp]
    def getVpcConnectorName: ZIO[Any, AwsError, VpcConnectorName] =
      AwsError.unwrapOptionField("vpcConnectorName", vpcConnectorName)
    def getVpcConnectorArn: ZIO[Any, AwsError, AppRunnerResourceArn] =
      AwsError.unwrapOptionField("vpcConnectorArn", vpcConnectorArn)
    def getVpcConnectorRevision: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("vpcConnectorRevision", vpcConnectorRevision)
    def getSubnets: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getSecurityGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.apprunner.model.VpcConnectorStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDeletedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deletedAt", deletedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.VpcConnector
  ) extends zio.aws.apprunner.model.VpcConnector.ReadOnly {
    override val vpcConnectorName: Optional[VpcConnectorName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConnectorName())
        .map(value =>
          zio.aws.apprunner.model.primitives.VpcConnectorName(value)
        )
    override val vpcConnectorArn: Optional[AppRunnerResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConnectorArn())
        .map(value =>
          zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
        )
    override val vpcConnectorRevision: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcConnectorRevision())
      .map(value => value: Integer)
    override val subnets: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnets())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val securityGroups: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val status: Optional[zio.aws.apprunner.model.VpcConnectorStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.apprunner.model.VpcConnectorStatus.wrap(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.apprunner.model.primitives.Timestamp(value))
    override val deletedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.deletedAt())
      .map(value => zio.aws.apprunner.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.VpcConnector
  ): zio.aws.apprunner.model.VpcConnector.ReadOnly = new Wrapper(impl)
}
