package zio.aws.apprunner.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeVpcConnectorResponse(
    vpcConnector: zio.aws.apprunner.model.VpcConnector
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.DescribeVpcConnectorResponse = {
    import DescribeVpcConnectorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.DescribeVpcConnectorResponse
      .builder()
      .vpcConnector(vpcConnector.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.DescribeVpcConnectorResponse.ReadOnly =
    zio.aws.apprunner.model.DescribeVpcConnectorResponse.wrap(buildAwsValue())
}
object DescribeVpcConnectorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.DescribeVpcConnectorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.DescribeVpcConnectorResponse =
      zio.aws.apprunner.model
        .DescribeVpcConnectorResponse(vpcConnector.asEditable)
    def vpcConnector: zio.aws.apprunner.model.VpcConnector.ReadOnly
    def getVpcConnector
        : ZIO[Any, Nothing, zio.aws.apprunner.model.VpcConnector.ReadOnly] =
      ZIO.succeed(vpcConnector)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.DescribeVpcConnectorResponse
  ) extends zio.aws.apprunner.model.DescribeVpcConnectorResponse.ReadOnly {
    override val vpcConnector: zio.aws.apprunner.model.VpcConnector.ReadOnly =
      zio.aws.apprunner.model.VpcConnector.wrap(impl.vpcConnector())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.DescribeVpcConnectorResponse
  ): zio.aws.apprunner.model.DescribeVpcConnectorResponse.ReadOnly =
    new Wrapper(impl)
}
