package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.{
  NullableBoolean,
  DomainName,
  AppRunnerResourceArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssociateCustomDomainRequest(
    serviceArn: AppRunnerResourceArn,
    domainName: DomainName,
    enableWWWSubdomain: Optional[NullableBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.AssociateCustomDomainRequest = {
    import AssociateCustomDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.AssociateCustomDomainRequest
      .builder()
      .serviceArn(AppRunnerResourceArn.unwrap(serviceArn): java.lang.String)
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .optionallyWith(
        enableWWWSubdomain.map(value => value: java.lang.Boolean)
      )(_.enableWWWSubdomain)
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.AssociateCustomDomainRequest.ReadOnly =
    zio.aws.apprunner.model.AssociateCustomDomainRequest.wrap(buildAwsValue())
}
object AssociateCustomDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.AssociateCustomDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.AssociateCustomDomainRequest =
      zio.aws.apprunner.model.AssociateCustomDomainRequest(
        serviceArn,
        domainName,
        enableWWWSubdomain.map(value => value)
      )
    def serviceArn: AppRunnerResourceArn
    def domainName: DomainName
    def enableWWWSubdomain: Optional[NullableBoolean]
    def getServiceArn: ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(serviceArn)
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getEnableWWWSubdomain: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("enableWWWSubdomain", enableWWWSubdomain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.AssociateCustomDomainRequest
  ) extends zio.aws.apprunner.model.AssociateCustomDomainRequest.ReadOnly {
    override val serviceArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives.AppRunnerResourceArn(impl.serviceArn())
    override val domainName: DomainName =
      zio.aws.apprunner.model.primitives.DomainName(impl.domainName())
    override val enableWWWSubdomain: Optional[NullableBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableWWWSubdomain())
        .map(value => value: NullableBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.AssociateCustomDomainRequest
  ): zio.aws.apprunner.model.AssociateCustomDomainRequest.ReadOnly =
    new Wrapper(impl)
}
