package zio.aws.apprunner.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.apprunner.model.primitives.{
  Timestamp,
  Integer,
  ObservabilityConfigurationName,
  AppRunnerResourceArn
}
import scala.jdk.CollectionConverters.*
final case class ObservabilityConfiguration(
    observabilityConfigurationArn: Optional[AppRunnerResourceArn] =
      Optional.Absent,
    observabilityConfigurationName: Optional[ObservabilityConfigurationName] =
      Optional.Absent,
    traceConfiguration: Optional[zio.aws.apprunner.model.TraceConfiguration] =
      Optional.Absent,
    observabilityConfigurationRevision: Optional[Integer] = Optional.Absent,
    latest: Optional[Boolean] = Optional.Absent,
    status: Optional[zio.aws.apprunner.model.ObservabilityConfigurationStatus] =
      Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    deletedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ObservabilityConfiguration = {
    import ObservabilityConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ObservabilityConfiguration
      .builder()
      .optionallyWith(
        observabilityConfigurationArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.observabilityConfigurationArn)
      .optionallyWith(
        observabilityConfigurationName.map(value =>
          ObservabilityConfigurationName.unwrap(value): java.lang.String
        )
      )(_.observabilityConfigurationName)
      .optionallyWith(traceConfiguration.map(value => value.buildAwsValue()))(
        _.traceConfiguration
      )
      .optionallyWith(
        observabilityConfigurationRevision.map(value =>
          value: java.lang.Integer
        )
      )(_.observabilityConfigurationRevision)
      .optionallyWith(latest.map(value => value: java.lang.Boolean))(_.latest)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(deletedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.deletedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.ObservabilityConfiguration.ReadOnly =
    zio.aws.apprunner.model.ObservabilityConfiguration.wrap(buildAwsValue())
}
object ObservabilityConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ObservabilityConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.ObservabilityConfiguration =
      zio.aws.apprunner.model.ObservabilityConfiguration(
        observabilityConfigurationArn.map(value => value),
        observabilityConfigurationName.map(value => value),
        traceConfiguration.map(value => value.asEditable),
        observabilityConfigurationRevision.map(value => value),
        latest.map(value => value),
        status.map(value => value),
        createdAt.map(value => value),
        deletedAt.map(value => value)
      )
    def observabilityConfigurationArn: Optional[AppRunnerResourceArn]
    def observabilityConfigurationName: Optional[ObservabilityConfigurationName]
    def traceConfiguration
        : Optional[zio.aws.apprunner.model.TraceConfiguration.ReadOnly]
    def observabilityConfigurationRevision: Optional[Integer]
    def latest: Optional[Boolean]
    def status
        : Optional[zio.aws.apprunner.model.ObservabilityConfigurationStatus]
    def createdAt: Optional[Timestamp]
    def deletedAt: Optional[Timestamp]
    def getObservabilityConfigurationArn
        : ZIO[Any, AwsError, AppRunnerResourceArn] = AwsError.unwrapOptionField(
      "observabilityConfigurationArn",
      observabilityConfigurationArn
    )
    def getObservabilityConfigurationName
        : ZIO[Any, AwsError, ObservabilityConfigurationName] =
      AwsError.unwrapOptionField(
        "observabilityConfigurationName",
        observabilityConfigurationName
      )
    def getTraceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.TraceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("traceConfiguration", traceConfiguration)
    def getObservabilityConfigurationRevision: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "observabilityConfigurationRevision",
        observabilityConfigurationRevision
      )
    def getLatest: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("latest", latest)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.ObservabilityConfigurationStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDeletedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deletedAt", deletedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ObservabilityConfiguration
  ) extends zio.aws.apprunner.model.ObservabilityConfiguration.ReadOnly {
    override val observabilityConfigurationArn: Optional[AppRunnerResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.observabilityConfigurationArn())
        .map(value =>
          zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
        )
    override val observabilityConfigurationName
        : Optional[ObservabilityConfigurationName] = zio.aws.core.internal
      .optionalFromNullable(impl.observabilityConfigurationName())
      .map(value =>
        zio.aws.apprunner.model.primitives.ObservabilityConfigurationName(value)
      )
    override val traceConfiguration
        : Optional[zio.aws.apprunner.model.TraceConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.traceConfiguration())
        .map(value => zio.aws.apprunner.model.TraceConfiguration.wrap(value))
    override val observabilityConfigurationRevision: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.observabilityConfigurationRevision())
        .map(value => value: Integer)
    override val latest: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.latest())
      .map(value => value: Boolean)
    override val status
        : Optional[zio.aws.apprunner.model.ObservabilityConfigurationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.apprunner.model.ObservabilityConfigurationStatus.wrap(value)
        )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.apprunner.model.primitives.Timestamp(value))
    override val deletedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.deletedAt())
      .map(value => zio.aws.apprunner.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ObservabilityConfiguration
  ): zio.aws.apprunner.model.ObservabilityConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
