package zio.aws.apprunner.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeObservabilityConfigurationResponse(
    observabilityConfiguration: zio.aws.apprunner.model.ObservabilityConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.DescribeObservabilityConfigurationResponse = {
    import DescribeObservabilityConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.DescribeObservabilityConfigurationResponse
      .builder()
      .observabilityConfiguration(observabilityConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.DescribeObservabilityConfigurationResponse.ReadOnly =
    zio.aws.apprunner.model.DescribeObservabilityConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeObservabilityConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.DescribeObservabilityConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.apprunner.model.DescribeObservabilityConfigurationResponse =
      zio.aws.apprunner.model.DescribeObservabilityConfigurationResponse(
        observabilityConfiguration.asEditable
      )
    def observabilityConfiguration
        : zio.aws.apprunner.model.ObservabilityConfiguration.ReadOnly
    def getObservabilityConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.apprunner.model.ObservabilityConfiguration.ReadOnly
    ] = ZIO.succeed(observabilityConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.DescribeObservabilityConfigurationResponse
  ) extends zio.aws.apprunner.model.DescribeObservabilityConfigurationResponse.ReadOnly {
    override val observabilityConfiguration
        : zio.aws.apprunner.model.ObservabilityConfiguration.ReadOnly =
      zio.aws.apprunner.model.ObservabilityConfiguration
        .wrap(impl.observabilityConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.DescribeObservabilityConfigurationResponse
  ): zio.aws.apprunner.model.DescribeObservabilityConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
