package zio.aws.apprunner.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.apprunner.model.primitives.{
  NextToken,
  MaxResults,
  AutoScalingConfigurationName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAutoScalingConfigurationsRequest(
    autoScalingConfigurationName: Optional[AutoScalingConfigurationName] =
      Optional.Absent,
    latestOnly: Optional[Boolean] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ListAutoScalingConfigurationsRequest = {
    import ListAutoScalingConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ListAutoScalingConfigurationsRequest
      .builder()
      .optionallyWith(
        autoScalingConfigurationName.map(value =>
          AutoScalingConfigurationName.unwrap(value): java.lang.String
        )
      )(_.autoScalingConfigurationName)
      .optionallyWith(latestOnly.map(value => value: java.lang.Boolean))(
        _.latestOnly
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.ListAutoScalingConfigurationsRequest.ReadOnly =
    zio.aws.apprunner.model.ListAutoScalingConfigurationsRequest
      .wrap(buildAwsValue())
}
object ListAutoScalingConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ListAutoScalingConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.apprunner.model.ListAutoScalingConfigurationsRequest =
      zio.aws.apprunner.model.ListAutoScalingConfigurationsRequest(
        autoScalingConfigurationName.map(value => value),
        latestOnly.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def autoScalingConfigurationName: Optional[AutoScalingConfigurationName]
    def latestOnly: Optional[Boolean]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getAutoScalingConfigurationName
        : ZIO[Any, AwsError, AutoScalingConfigurationName] =
      AwsError.unwrapOptionField(
        "autoScalingConfigurationName",
        autoScalingConfigurationName
      )
    def getLatestOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("latestOnly", latestOnly)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ListAutoScalingConfigurationsRequest
  ) extends zio.aws.apprunner.model.ListAutoScalingConfigurationsRequest.ReadOnly {
    override val autoScalingConfigurationName
        : Optional[AutoScalingConfigurationName] = zio.aws.core.internal
      .optionalFromNullable(impl.autoScalingConfigurationName())
      .map(value =>
        zio.aws.apprunner.model.primitives.AutoScalingConfigurationName(value)
      )
    override val latestOnly: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.latestOnly())
      .map(value => value: Boolean)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.apprunner.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.apprunner.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ListAutoScalingConfigurationsRequest
  ): zio.aws.apprunner.model.ListAutoScalingConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
