package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.{
  Integer,
  AutoScalingConfigurationName,
  AppRunnerResourceArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AutoScalingConfigurationSummary(
    autoScalingConfigurationArn: Optional[AppRunnerResourceArn] =
      Optional.Absent,
    autoScalingConfigurationName: Optional[AutoScalingConfigurationName] =
      Optional.Absent,
    autoScalingConfigurationRevision: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationSummary = {
    import AutoScalingConfigurationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationSummary
      .builder()
      .optionallyWith(
        autoScalingConfigurationArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.autoScalingConfigurationArn)
      .optionallyWith(
        autoScalingConfigurationName.map(value =>
          AutoScalingConfigurationName.unwrap(value): java.lang.String
        )
      )(_.autoScalingConfigurationName)
      .optionallyWith(
        autoScalingConfigurationRevision.map(value => value: java.lang.Integer)
      )(_.autoScalingConfigurationRevision)
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.AutoScalingConfigurationSummary.ReadOnly =
    zio.aws.apprunner.model.AutoScalingConfigurationSummary
      .wrap(buildAwsValue())
}
object AutoScalingConfigurationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.AutoScalingConfigurationSummary =
      zio.aws.apprunner.model.AutoScalingConfigurationSummary(
        autoScalingConfigurationArn.map(value => value),
        autoScalingConfigurationName.map(value => value),
        autoScalingConfigurationRevision.map(value => value)
      )
    def autoScalingConfigurationArn: Optional[AppRunnerResourceArn]
    def autoScalingConfigurationName: Optional[AutoScalingConfigurationName]
    def autoScalingConfigurationRevision: Optional[Integer]
    def getAutoScalingConfigurationArn
        : ZIO[Any, AwsError, AppRunnerResourceArn] = AwsError.unwrapOptionField(
      "autoScalingConfigurationArn",
      autoScalingConfigurationArn
    )
    def getAutoScalingConfigurationName
        : ZIO[Any, AwsError, AutoScalingConfigurationName] =
      AwsError.unwrapOptionField(
        "autoScalingConfigurationName",
        autoScalingConfigurationName
      )
    def getAutoScalingConfigurationRevision: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "autoScalingConfigurationRevision",
        autoScalingConfigurationRevision
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationSummary
  ) extends zio.aws.apprunner.model.AutoScalingConfigurationSummary.ReadOnly {
    override val autoScalingConfigurationArn: Optional[AppRunnerResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingConfigurationArn())
        .map(value =>
          zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
        )
    override val autoScalingConfigurationName
        : Optional[AutoScalingConfigurationName] = zio.aws.core.internal
      .optionalFromNullable(impl.autoScalingConfigurationName())
      .map(value =>
        zio.aws.apprunner.model.primitives.AutoScalingConfigurationName(value)
      )
    override val autoScalingConfigurationRevision: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingConfigurationRevision())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationSummary
  ): zio.aws.apprunner.model.AutoScalingConfigurationSummary.ReadOnly =
    new Wrapper(impl)
}
