package zio.aws.apprunner
import zio.aws.apprunner.model.DescribeCustomDomainsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.apprunner.model.{
  CreateObservabilityConfigurationRequest,
  DescribeVpcConnectorRequest,
  StartDeploymentRequest,
  DeleteServiceRequest,
  CreateConnectionRequest,
  CreateAutoScalingConfigurationRequest,
  ListVpcConnectorsRequest,
  ListTagsForResourceRequest,
  CreateVpcConnectorRequest,
  DeleteVpcConnectorRequest,
  DisassociateCustomDomainRequest,
  ListAutoScalingConfigurationsRequest,
  DeleteConnectionRequest,
  CreateServiceRequest,
  DeleteObservabilityConfigurationRequest,
  DescribeCustomDomainsRequest,
  DescribeServiceRequest,
  AssociateCustomDomainRequest,
  PauseServiceRequest,
  UntagResourceRequest,
  DescribeAutoScalingConfigurationRequest,
  DeleteAutoScalingConfigurationRequest,
  ListServicesRequest,
  ListConnectionsRequest,
  ListObservabilityConfigurationsRequest,
  UpdateServiceRequest,
  ResumeServiceRequest,
  ListOperationsRequest,
  TagResourceRequest,
  DescribeObservabilityConfigurationRequest
}
import zio.aws.core.{StreamingOutputResult, AwsError}
import software.amazon.awssdk.services.apprunner.AppRunnerAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object AppRunnerMock extends Mock[AppRunner] {
  object ListVpcConnectors
      extends Stream[
        ListVpcConnectorsRequest,
        AwsError,
        zio.aws.apprunner.model.VpcConnector.ReadOnly
      ]
  object ListVpcConnectorsPaginated
      extends Effect[
        ListVpcConnectorsRequest,
        AwsError,
        zio.aws.apprunner.model.ListVpcConnectorsResponse.ReadOnly
      ]
  object DescribeVpcConnector
      extends Effect[
        DescribeVpcConnectorRequest,
        AwsError,
        zio.aws.apprunner.model.DescribeVpcConnectorResponse.ReadOnly
      ]
  object ResumeService
      extends Effect[
        ResumeServiceRequest,
        AwsError,
        zio.aws.apprunner.model.ResumeServiceResponse.ReadOnly
      ]
  object AssociateCustomDomain
      extends Effect[
        AssociateCustomDomainRequest,
        AwsError,
        zio.aws.apprunner.model.AssociateCustomDomainResponse.ReadOnly
      ]
  object CreateService
      extends Effect[
        CreateServiceRequest,
        AwsError,
        zio.aws.apprunner.model.CreateServiceResponse.ReadOnly
      ]
  object CreateVpcConnector
      extends Effect[
        CreateVpcConnectorRequest,
        AwsError,
        zio.aws.apprunner.model.CreateVpcConnectorResponse.ReadOnly
      ]
  object CreateConnection
      extends Effect[
        CreateConnectionRequest,
        AwsError,
        zio.aws.apprunner.model.CreateConnectionResponse.ReadOnly
      ]
  object CreateAutoScalingConfiguration
      extends Effect[
        CreateAutoScalingConfigurationRequest,
        AwsError,
        zio.aws.apprunner.model.CreateAutoScalingConfigurationResponse.ReadOnly
      ]
  object DeleteService
      extends Effect[
        DeleteServiceRequest,
        AwsError,
        zio.aws.apprunner.model.DeleteServiceResponse.ReadOnly
      ]
  object ListServices
      extends Stream[
        ListServicesRequest,
        AwsError,
        zio.aws.apprunner.model.ServiceSummary.ReadOnly
      ]
  object ListServicesPaginated
      extends Effect[
        ListServicesRequest,
        AwsError,
        zio.aws.apprunner.model.ListServicesResponse.ReadOnly
      ]
  object DescribeCustomDomains
      extends Effect[
        DescribeCustomDomainsRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          ReadOnly,
          zio.aws.apprunner.model.CustomDomain.ReadOnly
        ]
      ]
  object DescribeCustomDomainsPaginated
      extends Effect[DescribeCustomDomainsRequest, AwsError, ReadOnly]
  object ListConnections
      extends Stream[
        ListConnectionsRequest,
        AwsError,
        zio.aws.apprunner.model.ConnectionSummary.ReadOnly
      ]
  object ListConnectionsPaginated
      extends Effect[
        ListConnectionsRequest,
        AwsError,
        zio.aws.apprunner.model.ListConnectionsResponse.ReadOnly
      ]
  object ListOperations
      extends Stream[
        ListOperationsRequest,
        AwsError,
        zio.aws.apprunner.model.OperationSummary.ReadOnly
      ]
  object ListOperationsPaginated
      extends Effect[
        ListOperationsRequest,
        AwsError,
        zio.aws.apprunner.model.ListOperationsResponse.ReadOnly
      ]
  object DeleteAutoScalingConfiguration
      extends Effect[
        DeleteAutoScalingConfigurationRequest,
        AwsError,
        zio.aws.apprunner.model.DeleteAutoScalingConfigurationResponse.ReadOnly
      ]
  object DeleteObservabilityConfiguration
      extends Effect[
        DeleteObservabilityConfigurationRequest,
        AwsError,
        zio.aws.apprunner.model.DeleteObservabilityConfigurationResponse.ReadOnly
      ]
  object PauseService
      extends Effect[
        PauseServiceRequest,
        AwsError,
        zio.aws.apprunner.model.PauseServiceResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.apprunner.model.UntagResourceResponse.ReadOnly
      ]
  object ListAutoScalingConfigurations
      extends Stream[
        ListAutoScalingConfigurationsRequest,
        AwsError,
        zio.aws.apprunner.model.AutoScalingConfigurationSummary.ReadOnly
      ]
  object ListAutoScalingConfigurationsPaginated
      extends Effect[
        ListAutoScalingConfigurationsRequest,
        AwsError,
        zio.aws.apprunner.model.ListAutoScalingConfigurationsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.apprunner.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DeleteConnection
      extends Effect[
        DeleteConnectionRequest,
        AwsError,
        zio.aws.apprunner.model.DeleteConnectionResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.apprunner.model.TagResourceResponse.ReadOnly
      ]
  object UpdateService
      extends Effect[
        UpdateServiceRequest,
        AwsError,
        zio.aws.apprunner.model.UpdateServiceResponse.ReadOnly
      ]
  object ListObservabilityConfigurations
      extends Stream[
        ListObservabilityConfigurationsRequest,
        AwsError,
        zio.aws.apprunner.model.ObservabilityConfigurationSummary.ReadOnly
      ]
  object ListObservabilityConfigurationsPaginated
      extends Effect[
        ListObservabilityConfigurationsRequest,
        AwsError,
        zio.aws.apprunner.model.ListObservabilityConfigurationsResponse.ReadOnly
      ]
  object DisassociateCustomDomain
      extends Effect[
        DisassociateCustomDomainRequest,
        AwsError,
        zio.aws.apprunner.model.DisassociateCustomDomainResponse.ReadOnly
      ]
  object CreateObservabilityConfiguration
      extends Effect[
        CreateObservabilityConfigurationRequest,
        AwsError,
        zio.aws.apprunner.model.CreateObservabilityConfigurationResponse.ReadOnly
      ]
  object DeleteVpcConnector
      extends Effect[
        DeleteVpcConnectorRequest,
        AwsError,
        zio.aws.apprunner.model.DeleteVpcConnectorResponse.ReadOnly
      ]
  object DescribeService
      extends Effect[
        DescribeServiceRequest,
        AwsError,
        zio.aws.apprunner.model.DescribeServiceResponse.ReadOnly
      ]
  object DescribeAutoScalingConfiguration
      extends Effect[
        DescribeAutoScalingConfigurationRequest,
        AwsError,
        zio.aws.apprunner.model.DescribeAutoScalingConfigurationResponse.ReadOnly
      ]
  object StartDeployment
      extends Effect[
        StartDeploymentRequest,
        AwsError,
        zio.aws.apprunner.model.StartDeploymentResponse.ReadOnly
      ]
  object DescribeObservabilityConfiguration
      extends Effect[
        DescribeObservabilityConfigurationRequest,
        AwsError,
        zio.aws.apprunner.model.DescribeObservabilityConfigurationResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, AppRunner] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, AppRunner] { rts =>
        ZIO.succeed {
          new AppRunner {
            val api: AppRunnerAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): AppRunner = this
            def listVpcConnectors(request: ListVpcConnectorsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.apprunner.model.VpcConnector.ReadOnly
            ] = rts.unsafeRun(proxy(ListVpcConnectors, request))
            def listVpcConnectorsPaginated(
                request: ListVpcConnectorsRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.ListVpcConnectorsResponse.ReadOnly
            ] = proxy(ListVpcConnectorsPaginated, request)
            def describeVpcConnector(request: DescribeVpcConnectorRequest): IO[
              AwsError,
              zio.aws.apprunner.model.DescribeVpcConnectorResponse.ReadOnly
            ] = proxy(DescribeVpcConnector, request)
            def resumeService(request: ResumeServiceRequest): IO[
              AwsError,
              zio.aws.apprunner.model.ResumeServiceResponse.ReadOnly
            ] = proxy(ResumeService, request)
            def associateCustomDomain(
                request: AssociateCustomDomainRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.AssociateCustomDomainResponse.ReadOnly
            ] = proxy(AssociateCustomDomain, request)
            def createService(request: CreateServiceRequest): IO[
              AwsError,
              zio.aws.apprunner.model.CreateServiceResponse.ReadOnly
            ] = proxy(CreateService, request)
            def createVpcConnector(request: CreateVpcConnectorRequest): IO[
              AwsError,
              zio.aws.apprunner.model.CreateVpcConnectorResponse.ReadOnly
            ] = proxy(CreateVpcConnector, request)
            def createConnection(request: CreateConnectionRequest): IO[
              AwsError,
              zio.aws.apprunner.model.CreateConnectionResponse.ReadOnly
            ] = proxy(CreateConnection, request)
            def createAutoScalingConfiguration(
                request: CreateAutoScalingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.CreateAutoScalingConfigurationResponse.ReadOnly
            ] = proxy(CreateAutoScalingConfiguration, request)
            def deleteService(request: DeleteServiceRequest): IO[
              AwsError,
              zio.aws.apprunner.model.DeleteServiceResponse.ReadOnly
            ] = proxy(DeleteService, request)
            def listServices(request: ListServicesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.apprunner.model.ServiceSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListServices, request))
            def listServicesPaginated(request: ListServicesRequest): IO[
              AwsError,
              zio.aws.apprunner.model.ListServicesResponse.ReadOnly
            ] = proxy(ListServicesPaginated, request)
            def describeCustomDomains(
                request: DescribeCustomDomainsRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              ReadOnly,
              zio.aws.apprunner.model.CustomDomain.ReadOnly
            ]] = proxy(DescribeCustomDomains, request)
            def describeCustomDomainsPaginated(
                request: DescribeCustomDomainsRequest
            ): IO[AwsError, ReadOnly] =
              proxy(DescribeCustomDomainsPaginated, request)
            def listConnections(request: ListConnectionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.apprunner.model.ConnectionSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListConnections, request))
            def listConnectionsPaginated(request: ListConnectionsRequest): IO[
              AwsError,
              zio.aws.apprunner.model.ListConnectionsResponse.ReadOnly
            ] = proxy(ListConnectionsPaginated, request)
            def listOperations(request: ListOperationsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.apprunner.model.OperationSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListOperations, request))
            def listOperationsPaginated(request: ListOperationsRequest): IO[
              AwsError,
              zio.aws.apprunner.model.ListOperationsResponse.ReadOnly
            ] = proxy(ListOperationsPaginated, request)
            def deleteAutoScalingConfiguration(
                request: DeleteAutoScalingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.DeleteAutoScalingConfigurationResponse.ReadOnly
            ] = proxy(DeleteAutoScalingConfiguration, request)
            def deleteObservabilityConfiguration(
                request: DeleteObservabilityConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.DeleteObservabilityConfigurationResponse.ReadOnly
            ] = proxy(DeleteObservabilityConfiguration, request)
            def pauseService(request: PauseServiceRequest): IO[
              AwsError,
              zio.aws.apprunner.model.PauseServiceResponse.ReadOnly
            ] = proxy(PauseService, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.apprunner.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def listAutoScalingConfigurations(
                request: ListAutoScalingConfigurationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.apprunner.model.AutoScalingConfigurationSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListAutoScalingConfigurations, request))
            def listAutoScalingConfigurationsPaginated(
                request: ListAutoScalingConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.ListAutoScalingConfigurationsResponse.ReadOnly
            ] = proxy(ListAutoScalingConfigurationsPaginated, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.apprunner.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def deleteConnection(request: DeleteConnectionRequest): IO[
              AwsError,
              zio.aws.apprunner.model.DeleteConnectionResponse.ReadOnly
            ] = proxy(DeleteConnection, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.apprunner.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def updateService(request: UpdateServiceRequest): IO[
              AwsError,
              zio.aws.apprunner.model.UpdateServiceResponse.ReadOnly
            ] = proxy(UpdateService, request)
            def listObservabilityConfigurations(
                request: ListObservabilityConfigurationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.apprunner.model.ObservabilityConfigurationSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListObservabilityConfigurations, request))
            def listObservabilityConfigurationsPaginated(
                request: ListObservabilityConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.ListObservabilityConfigurationsResponse.ReadOnly
            ] = proxy(ListObservabilityConfigurationsPaginated, request)
            def disassociateCustomDomain(
                request: DisassociateCustomDomainRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.DisassociateCustomDomainResponse.ReadOnly
            ] = proxy(DisassociateCustomDomain, request)
            def createObservabilityConfiguration(
                request: CreateObservabilityConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.CreateObservabilityConfigurationResponse.ReadOnly
            ] = proxy(CreateObservabilityConfiguration, request)
            def deleteVpcConnector(request: DeleteVpcConnectorRequest): IO[
              AwsError,
              zio.aws.apprunner.model.DeleteVpcConnectorResponse.ReadOnly
            ] = proxy(DeleteVpcConnector, request)
            def describeService(request: DescribeServiceRequest): IO[
              AwsError,
              zio.aws.apprunner.model.DescribeServiceResponse.ReadOnly
            ] = proxy(DescribeService, request)
            def describeAutoScalingConfiguration(
                request: DescribeAutoScalingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.DescribeAutoScalingConfigurationResponse.ReadOnly
            ] = proxy(DescribeAutoScalingConfiguration, request)
            def startDeployment(request: StartDeploymentRequest): IO[
              AwsError,
              zio.aws.apprunner.model.StartDeploymentResponse.ReadOnly
            ] = proxy(StartDeployment, request)
            def describeObservabilityConfiguration(
                request: DescribeObservabilityConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.apprunner.model.DescribeObservabilityConfigurationResponse.ReadOnly
            ] = proxy(DescribeObservabilityConfiguration, request)
          }
        }
      }
    }
  }
}
