package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeCustomDomainsResponse(
    dnsTarget: String,
    serviceArn: AppRunnerResourceArn,
    customDomains: Iterable[zio.aws.apprunner.model.CustomDomain],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.DescribeCustomDomainsResponse = {
    import DescribeCustomDomainsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.DescribeCustomDomainsResponse
      .builder()
      .dnsTarget(dnsTarget: java.lang.String)
      .serviceArn(AppRunnerResourceArn.unwrap(serviceArn): java.lang.String)
      .customDomains(customDomains.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.DescribeCustomDomainsResponse.ReadOnly =
    zio.aws.apprunner.model.DescribeCustomDomainsResponse.wrap(buildAwsValue())
}
object DescribeCustomDomainsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.DescribeCustomDomainsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.DescribeCustomDomainsResponse =
      zio.aws.apprunner.model.DescribeCustomDomainsResponse(
        dnsTarget,
        serviceArn,
        customDomains.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def dnsTarget: String
    def serviceArn: AppRunnerResourceArn
    def customDomains: List[zio.aws.apprunner.model.CustomDomain.ReadOnly]
    def nextToken: Optional[String]
    def getDnsTarget: ZIO[Any, Nothing, String] = ZIO.succeed(dnsTarget)
    def getServiceArn: ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(serviceArn)
    def getCustomDomains: ZIO[Any, Nothing, List[
      zio.aws.apprunner.model.CustomDomain.ReadOnly
    ]] = ZIO.succeed(customDomains)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.DescribeCustomDomainsResponse
  ) extends zio.aws.apprunner.model.DescribeCustomDomainsResponse.ReadOnly {
    override val dnsTarget: String = impl.dnsTarget(): String
    override val serviceArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives.AppRunnerResourceArn(impl.serviceArn())
    override val customDomains
        : List[zio.aws.apprunner.model.CustomDomain.ReadOnly] = impl
      .customDomains()
      .asScala
      .map { item =>
        zio.aws.apprunner.model.CustomDomain.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.DescribeCustomDomainsResponse
  ): zio.aws.apprunner.model.DescribeCustomDomainsResponse.ReadOnly =
    new Wrapper(impl)
}
