package zio.aws.apprunner.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.apprunner.model.primitives.{
  Timestamp,
  AppRunnerResourceArn,
  ServiceId,
  ServiceName
}
import scala.jdk.CollectionConverters.*
final case class ServiceSummary(
    serviceName: Optional[ServiceName] = Optional.Absent,
    serviceId: Optional[ServiceId] = Optional.Absent,
    serviceArn: Optional[AppRunnerResourceArn] = Optional.Absent,
    serviceUrl: Optional[String] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent,
    status: Optional[zio.aws.apprunner.model.ServiceStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ServiceSummary = {
    import ServiceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ServiceSummary
      .builder()
      .optionallyWith(
        serviceName.map(value => ServiceName.unwrap(value): java.lang.String)
      )(_.serviceName)
      .optionallyWith(
        serviceId.map(value => ServiceId.unwrap(value): java.lang.String)
      )(_.serviceId)
      .optionallyWith(
        serviceArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.serviceArn)
      .optionallyWith(serviceUrl.map(value => value: java.lang.String))(
        _.serviceUrl
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.ServiceSummary.ReadOnly =
    zio.aws.apprunner.model.ServiceSummary.wrap(buildAwsValue())
}
object ServiceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ServiceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.ServiceSummary =
      zio.aws.apprunner.model.ServiceSummary(
        serviceName.map(value => value),
        serviceId.map(value => value),
        serviceArn.map(value => value),
        serviceUrl.map(value => value),
        createdAt.map(value => value),
        updatedAt.map(value => value),
        status.map(value => value)
      )
    def serviceName: Optional[ServiceName]
    def serviceId: Optional[ServiceId]
    def serviceArn: Optional[AppRunnerResourceArn]
    def serviceUrl: Optional[String]
    def createdAt: Optional[Timestamp]
    def updatedAt: Optional[Timestamp]
    def status: Optional[zio.aws.apprunner.model.ServiceStatus]
    def getServiceName: ZIO[Any, AwsError, ServiceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getServiceId: ZIO[Any, AwsError, ServiceId] =
      AwsError.unwrapOptionField("serviceId", serviceId)
    def getServiceArn: ZIO[Any, AwsError, AppRunnerResourceArn] =
      AwsError.unwrapOptionField("serviceArn", serviceArn)
    def getServiceUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceUrl", serviceUrl)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getStatus: ZIO[Any, AwsError, zio.aws.apprunner.model.ServiceStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ServiceSummary
  ) extends zio.aws.apprunner.model.ServiceSummary.ReadOnly {
    override val serviceName: Optional[ServiceName] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => zio.aws.apprunner.model.primitives.ServiceName(value))
    override val serviceId: Optional[ServiceId] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceId())
      .map(value => zio.aws.apprunner.model.primitives.ServiceId(value))
    override val serviceArn: Optional[AppRunnerResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceArn())
        .map(value =>
          zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
        )
    override val serviceUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceUrl())
      .map(value => value: String)
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.apprunner.model.primitives.Timestamp(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.apprunner.model.primitives.Timestamp(value))
    override val status: Optional[zio.aws.apprunner.model.ServiceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.apprunner.model.ServiceStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ServiceSummary
  ): zio.aws.apprunner.model.ServiceSummary.ReadOnly = new Wrapper(impl)
}
