package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: AppRunnerResourceArn,
    tags: Iterable[zio.aws.apprunner.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.TagResourceRequest
      .builder()
      .resourceArn(AppRunnerResourceArn.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.TagResourceRequest.ReadOnly =
    zio.aws.apprunner.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.TagResourceRequest =
      zio.aws.apprunner.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: AppRunnerResourceArn
    def tags: List[zio.aws.apprunner.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, List[zio.aws.apprunner.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.TagResourceRequest
  ) extends zio.aws.apprunner.model.TagResourceRequest.ReadOnly {
    override val resourceArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives
        .AppRunnerResourceArn(impl.resourceArn())
    override val tags: List[zio.aws.apprunner.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.apprunner.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.TagResourceRequest
  ): zio.aws.apprunner.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
