package zio.aws.apprunner.model
import scala.jdk.CollectionConverters.*
sealed trait CertificateValidationRecordStatus {
  def unwrap: software.amazon.awssdk.services.apprunner.model.CertificateValidationRecordStatus
}
object CertificateValidationRecordStatus {
  def wrap(
      value: software.amazon.awssdk.services.apprunner.model.CertificateValidationRecordStatus
  ): zio.aws.apprunner.model.CertificateValidationRecordStatus = value match {
    case software.amazon.awssdk.services.apprunner.model.CertificateValidationRecordStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apprunner.model.CertificateValidationRecordStatus.PENDING_VALIDATION =>
      val r = PENDING_VALIDATION
      r
    case software.amazon.awssdk.services.apprunner.model.CertificateValidationRecordStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.apprunner.model.CertificateValidationRecordStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apprunner.model.CertificateValidationRecordStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.CertificateValidationRecordStatus =
      software.amazon.awssdk.services.apprunner.model.CertificateValidationRecordStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING_VALIDATION
      extends zio.aws.apprunner.model.CertificateValidationRecordStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.CertificateValidationRecordStatus =
      software.amazon.awssdk.services.apprunner.model.CertificateValidationRecordStatus.PENDING_VALIDATION
  }
  case object SUCCESS
      extends zio.aws.apprunner.model.CertificateValidationRecordStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.CertificateValidationRecordStatus =
      software.amazon.awssdk.services.apprunner.model.CertificateValidationRecordStatus.SUCCESS
  }
  case object FAILED
      extends zio.aws.apprunner.model.CertificateValidationRecordStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.CertificateValidationRecordStatus =
      software.amazon.awssdk.services.apprunner.model.CertificateValidationRecordStatus.FAILED
  }
}
