package zio.aws.apprunner.model
import java.lang.Integer
import zio.aws.apprunner.model.primitives.{
  NextToken,
  MaxResults,
  ConnectionName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListConnectionsRequest(
    connectionName: Option[ConnectionName] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ListConnectionsRequest = {
    import ListConnectionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ListConnectionsRequest
      .builder()
      .optionallyWith(
        connectionName.map(value =>
          ConnectionName.unwrap(value): java.lang.String
        )
      )(_.connectionName)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.ListConnectionsRequest.ReadOnly =
    zio.aws.apprunner.model.ListConnectionsRequest.wrap(buildAwsValue())
}
object ListConnectionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ListConnectionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.ListConnectionsRequest =
      zio.aws.apprunner.model.ListConnectionsRequest(
        connectionName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def connectionName: Option[ConnectionName]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getConnectionName: ZIO[Any, AwsError, ConnectionName] =
      AwsError.unwrapOptionField("connectionName", connectionName)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ListConnectionsRequest
  ) extends zio.aws.apprunner.model.ListConnectionsRequest.ReadOnly {
    override val connectionName: Option[ConnectionName] = scala
      .Option(impl.connectionName())
      .map(value => zio.aws.apprunner.model.primitives.ConnectionName(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.apprunner.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.apprunner.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ListConnectionsRequest
  ): zio.aws.apprunner.model.ListConnectionsRequest.ReadOnly = new Wrapper(impl)
}
