package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeVpcConnectorRequest(
    vpcConnectorArn: AppRunnerResourceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.DescribeVpcConnectorRequest = {
    import DescribeVpcConnectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.DescribeVpcConnectorRequest
      .builder()
      .vpcConnectorArn(
        AppRunnerResourceArn.unwrap(vpcConnectorArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.DescribeVpcConnectorRequest.ReadOnly =
    zio.aws.apprunner.model.DescribeVpcConnectorRequest.wrap(buildAwsValue())
}
object DescribeVpcConnectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.DescribeVpcConnectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.DescribeVpcConnectorRequest =
      zio.aws.apprunner.model.DescribeVpcConnectorRequest(vpcConnectorArn)
    def vpcConnectorArn: AppRunnerResourceArn
    def getVpcConnectorArn: ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(vpcConnectorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.DescribeVpcConnectorRequest
  ) extends zio.aws.apprunner.model.DescribeVpcConnectorRequest.ReadOnly {
    override val vpcConnectorArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives
        .AppRunnerResourceArn(impl.vpcConnectorArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.DescribeVpcConnectorRequest
  ): zio.aws.apprunner.model.DescribeVpcConnectorRequest.ReadOnly = new Wrapper(
    impl
  )
}
