package zio.aws.apprunner.model
import java.lang.Integer
import zio.aws.apprunner.model.primitives.ServiceMaxResults
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListServicesRequest(
    nextToken: Option[String] = None,
    maxResults: Option[ServiceMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ListServicesRequest = {
    import ListServicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ListServicesRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => ServiceMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.ListServicesRequest.ReadOnly =
    zio.aws.apprunner.model.ListServicesRequest.wrap(buildAwsValue())
}
object ListServicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ListServicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.ListServicesRequest =
      zio.aws.apprunner.model.ListServicesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[String]
    def maxResults: Option[ServiceMaxResults]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ServiceMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ListServicesRequest
  ) extends zio.aws.apprunner.model.ListServicesRequest.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[ServiceMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.apprunner.model.primitives.ServiceMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ListServicesRequest
  ): zio.aws.apprunner.model.ListServicesRequest.ReadOnly = new Wrapper(impl)
}
